(function () {
var importcss = (function () {
  'use strict';

  var global = tinymce.util.Tools.resolve('tinymce.PluginManager');

  var global$1 = tinymce.util.Tools.resolve('tinymce.dom.DOMUtils');

  var global$2 = tinymce.util.Tools.resolve('tinymce.EditorManager');

  var global$3 = tinymce.util.Tools.resolve('tinymce.Env');

  var global$4 = tinymce.util.Tools.resolve('tinymce.util.Tools');

  var shouldMergeClasses = function (editor) {
    return editor.getParam('importcss_merge_classes');
  };
  var shouldImportExclusive = function (editor) {
    return editor.getParam('importcss_exclusive');
  };
  var getSelectorConverter = function (editor) {
    return editor.getParam('importcss_selector_converter');
  };
  var getSelectorFilter = function (editor) {
    return editor.getParam('importcss_selector_filter');
  };
  var getCssGroups = function (editor) {
    return editor.getParam('importcss_groups');
  };
  var shouldAppend = function (editor) {
    return editor.getParam('importcss_append');
  };
  var getFileFilter = function (editor) {
    return editor.getParam('importcss_file_filter');
  };
  var $_fk1yq1ekjfuvixbf = {
    shouldMergeClasses: shouldMergeClasses,
    shouldImportExclusive: shouldImportExclusive,
    getSelectorConverter: getSelectorConverter,
    getSelectorFilter: getSelectorFilter,
    getCssGroups: getCssGroups,
    shouldAppend: shouldAppend,
    getFileFilter: getFileFilter
  };

  var removeCacheSuffix = function (url) {
    var cacheSuffix = global$3.cacheSuffix;
    if (typeof url === 'string') {
      url = url.replace('?' + cacheSuffix, '').replace('&' + cacheSuffix, '');
    }
    return url;
  };
  var isSkinContentCss = function (editor, href) {
    var settings = editor.settings, skin = settings.skin !== false ? settings.skin || 'lightgray' : false;
    if (skin) {
      var skinUrl = settings.skin_url ? editor.documentBaseURI.toAbsolute(settings.skin_url) : global$2.baseURL + '/skins/' + skin;
      return href === skinUrl + '/content' + (editor.inline ? '.inline' : '') + '.min.css';
    }
    return false;
  };
  var compileFilter = function (filter) {
    if (typeof filter === 'string') {
      return function (value) {
        return value.indexOf(filter) !== -1;
      };
    } else if (filter instanceof RegExp) {
      return function (value) {
        return filter.test(value);
      };
    }
    return filter;
  };
  var getSelectors = function (editor, doc, fileFilter) {
    var selectors = [], contentCSSUrls = {};
    function append(styleSheet, imported) {
      var href = styleSheet.href, rules;
      href = removeCacheSuffix(href);
      if (!href || !fileFilter(href, imported) || isSkinContentCss(editor, href)) {
        return;
      }
      global$4.each(styleSheet.imports, function (styleSheet) {
        append(styleSheet, true);
      });
      try {
        rules = styleSheet.cssRules || styleSheet.rules;
      } catch (e) {
      }
      global$4.each(rules, function (cssRule) {
        if (cssRule.styleSheet) {
          append(cssRule.styleSheet, true);
        } else if (cssRule.selectorText) {
          global$4.each(cssRule.selectorText.split(','), function (selector) {
            selectors.push(global$4.trim(selector));
          });
        }
      });
    }
    global$4.each(editor.contentCSS, function (url) {
      contentCSSUrls[url] = true;
    });
    if (!fileFilter) {
      fileFilter = function (href, imported) {
        return imported || contentCSSUrls[href];
      };
    }
    try {
      global$4.each(doc.styleSheets, function (styleSheet) {
        append(styleSheet);
      });
    } catch (e) {
    }
    return selectors;
  };
  var defaultConvertSelectorToFormat = function (editor, selectorText) {
    var format;
    var selector = /^(?:([a-z0-9\-_]+))?(\.[a-z0-9_\-\.]+)$/i.exec(selectorText);
    if (!selector) {
      return;
    }
    var elementName = selector[1];
    var classes = selector[2].substr(1).split('.').join(' ');
    var inlineSelectorElements = global$4.makeMap('a,img');
    if (selector[1]) {
      format = { title: selectorText };
      if (editor.schema.getTextBlockElements()[elementName]) {
        format.block = elementName;
      } else if (editor.schema.getBlockElements()[elementName] || inlineSelectorElements[elementName.toLowerCase()]) {
        format.selector = elementName;
      } else {
        format.inline = elementName;
      }
    } else if (selector[2]) {
      format = {
        inline: 'span',
        title: selectorText.substr(1),
        classes: classes
      };
    }
    if ($_fk1yq1ekjfuvixbf.shouldMergeClasses(editor) !== false) {
      format.classes = classes;
    } else {
      format.attributes = { class: classes };
    }
    return format;
  };
  var getGroupsBySelector = function (groups, selector) {
    return global$4.grep(groups, function (group) {
      return !group.filter || group.filter(selector);
    });
  };
  var compileUserDefinedGroups = function (groups) {
    return global$4.map(groups, function (group) {
      return global$4.extend({}, group, {
        original: group,
        selectors: {},
        filter: compileFilter(group.filter),
        item: {
          text: group.title,
          menu: []
        }
      });
    });
  };
  var isExclusiveMode = function (editor, group) {
    return group === null || $_fk1yq1ekjfuvixbf.shouldImportExclusive(editor) !== false;
  };
  var isUniqueSelector = function (editor, selector, group, globallyUniqueSelectors) {
    return !(isExclusiveMode(editor, group) ? selector in globallyUniqueSelectors : selector in group.selectors);
  };
  var markUniqueSelector = function (editor, selector, group, globallyUniqueSelectors) {
    if (isExclusiveMode(editor, group)) {
      globallyUniqueSelectors[selector] = true;
    } else {
      group.selectors[selector] = true;
    }
  };
  var convertSelectorToFormat = function (editor, plugin, selector, group) {
    var selectorConverter;
    if (group && group.selector_converter) {
      selectorConverter = group.selector_converter;
    } else if ($_fk1yq1ekjfuvixbf.getSelectorConverter(editor)) {
      selectorConverter = $_fk1yq1ekjfuvixbf.getSelectorConverter(editor);
    } else {
      selectorConverter = function () {
        return defaultConvertSelectorToFormat(editor, selector);
      };
    }
    return selectorConverter.call(plugin, selector, group);
  };
  var setup = function (editor) {
    editor.on('renderFormatsMenu', function (e) {
      var globallyUniqueSelectors = {};
      var selectorFilter = compileFilter($_fk1yq1ekjfuvixbf.getSelectorFilter(editor)), ctrl = e.control;
      var groups = compileUserDefinedGroups($_fk1yq1ekjfuvixbf.getCssGroups(editor));
      var processSelector = function (selector, group) {
        if (isUniqueSelector(editor, selector, group, globallyUniqueSelectors)) {
          markUniqueSelector(editor, selector, group, globallyUniqueSelectors);
          var format = convertSelectorToFormat(editor, editor.plugins.importcss, selector, group);
          if (format) {
            var formatName = format.name || global$1.DOM.uniqueId();
            editor.formatter.register(formatName, format);
            return global$4.extend({}, ctrl.settings.itemDefaults, {
              text: format.title,
              format: formatName
            });
          }
        }
        return null;
      };
      if (!$_fk1yq1ekjfuvixbf.shouldAppend(editor)) {
        ctrl.items().remove();
      }
      global$4.each(getSelectors(editor, e.doc || editor.getDoc(), compileFilter($_fk1yq1ekjfuvixbf.getFileFilter(editor))), function (selector) {
        if (selector.indexOf('.mce-') === -1) {
          if (!selectorFilter || selectorFilter(selector)) {
            var selectorGroups = getGroupsBySelector(groups, selector);
            if (selectorGroups.length > 0) {
              global$4.each(selectorGroups, function (group) {
                var menuItem = processSelector(selector, group);
                if (menuItem) {
                  group.item.menu.push(menuItem);
                }
              });
            } else {
              var menuItem = processSelector(selector, null);
              if (menuItem) {
                ctrl.add(menuItem);
              }
            }
          }
        }
      });
      global$4.each(groups, function (group) {
        if (group.item.menu.length > 0) {
          ctrl.add(group.item);
        }
      });
      e.control.renderNew();
    });
  };
  var $_5jwc62efjfuvixb9 = {
    defaultConvertSelectorToFormat: defaultConvertSelectorToFormat,
    setup: setup
  };

  var get = function (editor) {
    var convertSelectorToFormat = function (selectorText) {
      return $_5jwc62efjfuvixb9.defaultConvertSelectorToFormat(editor, selectorText);
    };
    return { convertSelectorToFormat: convertSelectorToFormat };
  };
  var $_fn57p9eejfuvixb6 = { get: get };

  global.add('importcss', function (editor) {
    $_5jwc62efjfuvixb9.setup(editor);
    return $_fn57p9eejfuvixb6.get(editor);
  });
  function Plugin () {
  }

  return Plugin;

}());
})();
