#ifndef CONFIG
#define CONFIG "config.h"
#endif // CONFIG
#include CONFIG

#ifndef NO_INTERNAL_DATA

#include "kmsdata.h"

uint8_t DefaultKmsData[] =
{
	0x4B, 0x4D, 0x44, 0x00, 0x06, 0x00, 0x01, 0x00, 0x06, 0x01, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,   // KMD.............
	0x1D, 0x00, 0x00, 0x00, 0xCA, 0x00, 0x00, 0x00, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ..............
	0x20, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   //  ..............
	0x00, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0xC0, 0x97, 0xD7, 0x20,   // ............ 
	0xBF, 0xC4, 0x08, 0x22, 0x32, 0x00, 0x00, 0x00, 0x3A, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ."2...:.......
	0x60, 0x00, 0x00, 0x00, 0xC0, 0x7F, 0xDC, 0x0B, 0x7F, 0x6A, 0xFE, 0x0C, 0x0A, 0x00, 0x00, 0x00,   // `......j.....
	0x77, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCE, 0x00, 0x00, 0x00, 0x80, 0x8E, 0xF2, 0x0D,   // w.............
	0xFF, 0x3F, 0x42, 0x0F, 0x0A, 0x00, 0x00, 0x00, 0xB4, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // ?B............
	0xCE, 0x00, 0x00, 0x00, 0x40, 0x17, 0x0C, 0x1A, 0xBF, 0xC8, 0x5B, 0x1B, 0x0A, 0x00, 0x00, 0x00,   // ...@...[.....
	0xF1, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x0F, 0x00, 0x00, 0xC0, 0xE1, 0xE4, 0x00,   // ............
	0xFF, 0xC9, 0x9A, 0x3B, 0x32, 0x00, 0x00, 0x00, 0x2F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   // .;2.../.......
	0xCE, 0x00, 0x00, 0x00, 0x80, 0x5A, 0xB2, 0x27, 0x7F, 0x87, 0xE3, 0x28, 0x0A, 0x00, 0x00, 0x00,   // ....Z'..(....
	0x34, 0x27, 0xC9, 0x55, 0x82, 0xD6, 0x71, 0x4D, 0x98, 0x3E, 0xD6, 0xEC, 0x3F, 0x16, 0x05, 0x9F,   // 4'U.qM.>?...
	0x6C, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 0x00, 0x00,   // l..........2....
	0x81, 0x28, 0xA5, 0x59, 0x89, 0xA9, 0x9D, 0x47, 0xAF, 0x46, 0xF2, 0x75, 0xC6, 0x37, 0x06, 0x63,   // .(Y..GFu7.c
	0x74, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x01, 0x00,   // t...............
	0x15, 0xCE, 0xF1, 0x0F, 0x89, 0xA9, 0x9D, 0x47, 0xAF, 0x46, 0xF2, 0x75, 0xC6, 0x37, 0x06, 0x63,   // ....GFu7.c
	0x7F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x05, 0x00,   // ................
	0xFB, 0xB1, 0x49, 0x84, 0xEA, 0xF0, 0x7A, 0x49, 0x99, 0xAB, 0x66, 0xCA, 0x96, 0xE9, 0xA0, 0xF5,   // I.zI.f..
	0x8B, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // ................
	0x59, 0x56, 0xB1, 0x11, 0x03, 0xE6, 0xF1, 0x4C, 0x9C, 0x1F, 0xF0, 0xEC, 0x01, 0xB8, 0x18, 0x88,   // YV..L.....
	0x9F, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // ................
	0x36, 0xD6, 0x7C, 0xD2, 0x62, 0x19, 0xE9, 0x44, 0x8B, 0x4F, 0x27, 0xB6, 0xC2, 0x3E, 0xFB, 0x85,   // 6|b.D.O'>.
	0xB8, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // ...............
	0x23, 0xBF, 0xA0, 0x7B, 0xF5, 0xD0, 0x72, 0x40, 0x91, 0xD9, 0xD5, 0x5A, 0xF5, 0xA4, 0x81, 0xB6,   // #.{r@.Z.
	0xD4, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x04, 0x00,   // ...............
	0xC0, 0xE3, 0x9F, 0x96, 0xEC, 0xA3, 0x1A, 0x49, 0x9F, 0x25, 0x42, 0x36, 0x05, 0xDE, 0xB3, 0x65,   // ...I.%B6.޳e
	0xF0, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // ...............
	0x58, 0x13, 0xC5, 0xE1, 0x3E, 0xFE, 0x03, 0x42, 0xA4, 0xA2, 0x3B, 0x6B, 0x20, 0xC9, 0x73, 0x4E,   // X.>.B;k sN
	0x09, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // . ..............
	0x4F, 0x13, 0xE2, 0x58, 0x11, 0x8E, 0x17, 0x4D, 0x9C, 0xB2, 0x91, 0x06, 0x9C, 0x15, 0x11, 0x48,   // O.X...M......H
	0x1D, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // . ..............
	0x19, 0x52, 0xDE, 0x7F, 0xFA, 0xFB, 0x4A, 0x48, 0x82, 0xC9, 0x34, 0xD1, 0xAD, 0x53, 0xE8, 0x56,   // .R.JH.4ѭSV
	0x36, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // 6 ..............
	0x3B, 0x7B, 0xB9, 0xBB, 0xA4, 0x8C, 0x28, 0x4A, 0x97, 0x17, 0x89, 0xFA, 0xBD, 0x42, 0xC4, 0xAC,   // ;{.(J...BĬ
	0x40, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00,   // @ ..............
	0x58, 0xB3, 0x40, 0x3C, 0x48, 0x59, 0xAF, 0x45, 0x92, 0x3B, 0x53, 0xD2, 0x1F, 0xCC, 0x7E, 0x79,   // X@<HYE.;S.~y
	0x53, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00,   // S ..............
	0x90, 0x68, 0x64, 0x6D, 0x06, 0x36, 0x1A, 0x46, 0x86, 0xAB, 0x59, 0x8B, 0xB8, 0x4A, 0xCE, 0x82,   // .hdm.6.F.Y.J.
	0x66, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // f ..............
	0x80, 0xC7, 0x8F, 0xCB, 0x05, 0x2C, 0x5A, 0x49, 0x97, 0x10, 0x85, 0xAF, 0xFF, 0xC9, 0x04, 0xD7,   // ...,ZI....
	0x7B, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // { ..............
	0xBB, 0xA0, 0x94, 0x5F, 0xA0, 0xD5, 0x81, 0x40, 0xA6, 0x85, 0x58, 0x19, 0x41, 0x8B, 0x2F, 0xE0,   // .._..@.X.A./
	0x90, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00,   // . ..............
	0xE4, 0x56, 0xE1, 0x33, 0x6F, 0xB7, 0x52, 0x4A, 0x9F, 0x91, 0xF6, 0x41, 0xDD, 0x95, 0xAC, 0x48,   // V3oRJ..A.H
	0xA0, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // . ..............
	0x87, 0x33, 0xE5, 0x8F, 0x87, 0x30, 0x47, 0x44, 0x89, 0x85, 0xF7, 0x51, 0x32, 0x21, 0x5A, 0xC9,   // .3..0GD..Q2!Z
	0xC4, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   //  ..............
	0xF3, 0xFD, 0x21, 0x8A, 0xC5, 0xCB, 0xEB, 0x44, 0x83, 0xF3, 0xFE, 0x28, 0x4E, 0x66, 0x80, 0xA7,   // !.D.(Nf.
	0xF4, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   //  ..............
	0xAF, 0xCC, 0xC6, 0x0F, 0x0E, 0xFF, 0xAE, 0x4F, 0x9D, 0x08, 0x43, 0x70, 0x78, 0x5B, 0xF7, 0xED,   // ..O..Cpx[
	0x17, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // .!..............
	0xB6, 0xF5, 0x87, 0xCA, 0x46, 0xCD, 0xC0, 0x40, 0xB0, 0x6D, 0x8E, 0xCD, 0x57, 0xA4, 0x37, 0x3F,   // .F@m.W7?
	0x3E, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // >!..............
	0x89, 0x26, 0xCA, 0xB2, 0xA8, 0xA9, 0xD7, 0x42, 0x93, 0x8D, 0xCF, 0x8E, 0x9F, 0x20, 0x19, 0x58,   // .&ʲB.... .X
	0x71, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // q!..............
	0x71, 0xCB, 0x65, 0x86, 0x8C, 0x46, 0xA3, 0x4A, 0xA3, 0x37, 0xCB, 0x9B, 0xC9, 0xD5, 0xEA, 0xAC,   // qe..FJ7.
	0x97, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00,   // .!..............
	0xD3, 0xEF, 0x56, 0x84, 0x04, 0x0C, 0x89, 0x40, 0x87, 0x40, 0x5B, 0x72, 0x38, 0x53, 0x5A, 0x65,   // V....@.@[r8SZe
	0xAB, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // !..............
	0x69, 0xC0, 0x9F, 0x6E, 0x7D, 0x25, 0xC4, 0x4B, 0xB4, 0xA7, 0x75, 0x05, 0x14, 0xD3, 0x27, 0x43,   // i.n}%Ku..'C
	0xC2, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // !..............
	0x70, 0x52, 0x5F, 0x6D, 0xAC, 0x31, 0x3E, 0x43, 0xB9, 0x0A, 0x39, 0x89, 0x29, 0x23, 0xC6, 0x57,   // pR_m1>C.9.)#W
	0xD6, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00, 0x01, 0x00, 0x00,   // !..............
	0xDC, 0x64, 0x2A, 0x21, 0xB1, 0x43, 0x3D, 0x4D, 0xA3, 0x0C, 0x2F, 0xC6, 0x9D, 0x20, 0x95, 0xC6,   // d*!C=M./. .
	0xED, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // !..............
	0x46, 0xF9, 0x5A, 0xE8, 0x25, 0x2E, 0xB7, 0x47, 0x83, 0xE1, 0xBE, 0xBC, 0xEB, 0xEA, 0xC6, 0x11,   // FZ%.G.ᾼ.
	0xFB, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // !..............
	0xBF, 0xF1, 0xA6, 0xE6, 0x40, 0x9D, 0xC3, 0x40, 0xAA, 0x9F, 0xC7, 0x7B, 0xA2, 0x15, 0x78, 0xC0,   // @.@.{.x
	0x07, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // ."..............
	0x68, 0x79, 0x4C, 0xAA, 0xDA, 0xB9, 0x80, 0x46, 0x92, 0xB6, 0xAC, 0xB2, 0x5E, 0x2F, 0x86, 0x6C,   // hyLڹ.F.^/.l
	0x13, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // ."..............
	0x1B, 0xF6, 0xB5, 0x85, 0x0B, 0x32, 0xE3, 0x4B, 0x81, 0x4A, 0xB7, 0x6B, 0x2B, 0xFA, 0xFC, 0x82,   // ...2K.Jk+.
	0x2D, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // -"..............
	0xB1, 0x9E, 0x7D, 0x61, 0x36, 0xEF, 0x82, 0x4F, 0x86, 0xE0, 0xA6, 0x5A, 0xE0, 0x7B, 0x96, 0xC6,   // .}a6.O.Z{.
	0x39, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x00, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // 9"..............
	0x62, 0xEB, 0xE8, 0x8D, 0xE0, 0xBB, 0xAC, 0x40, 0xAC, 0x17, 0xF7, 0x55, 0x95, 0x07, 0x1E, 0xA3,   // b.໬@.U...
	0x45, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // E"..............
	0xF0, 0xC1, 0x9C, 0xA9, 0x19, 0x77, 0x06, 0x43, 0x96, 0x45, 0x29, 0x41, 0x02, 0xFB, 0xFF, 0x95,   // ..w.C.E)A..
	0x5F, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // _"..............
	0x55, 0xAE, 0xE1, 0x34, 0xF8, 0x27, 0x50, 0x49, 0x88, 0x77, 0x7A, 0x03, 0xBE, 0x5F, 0xB1, 0x81,   // U4'PI.wz._.
	0x7E, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // ~"..............
	0xBB, 0x3C, 0x4D, 0x03, 0x4B, 0x5D, 0x45, 0x42, 0xB3, 0xF8, 0xF8, 0x45, 0x71, 0x31, 0x40, 0x78,   // <M.K]EBEq1@x
	0x9D, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // ."..............
	0xFD, 0xEA, 0x32, 0xDE, 0xEE, 0xAA, 0x62, 0x46, 0x94, 0x44, 0xC1, 0xBE, 0xFB, 0x41, 0xBD, 0xE2,   // 2bF.DA
	0xBC, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // "..............
	0xE5, 0x62, 0xC3, 0x90, 0xA1, 0x0D, 0xFD, 0x4B, 0xB5, 0x3B, 0xB8, 0x7D, 0x30, 0x9A, 0xDE, 0x43,   // b..K;}0.C
	0xD9, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // "..............
	0x7C, 0x95, 0xE3, 0x73, 0x0C, 0xFC, 0x0D, 0x40, 0x91, 0x84, 0x5F, 0x7B, 0x6F, 0x2E, 0xB4, 0x09,   // |.s..@.._{o..
	0x0E, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // .#..............
	0xB3, 0xFA, 0xD2, 0x32, 0xA8, 0xE4, 0xC2, 0x42, 0x92, 0x3B, 0x4B, 0xF4, 0xFD, 0x13, 0xE6, 0xEE,   // 2B.;K.
	0x41, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // A#..............
	0x33, 0xA3, 0x03, 0x71, 0xC8, 0xB8, 0xCC, 0x49, 0x93, 0xCE, 0xD3, 0x7C, 0x09, 0x68, 0x7F, 0x92,   // 3.qȸI.|.h..
	0x61, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // a#..............
	0x83, 0xD3, 0xB2, 0xE0, 0x12, 0xD1, 0x3F, 0x41, 0x8A, 0x80, 0x97, 0xF3, 0x73, 0xA5, 0x82, 0x0C,   // .Ӳ.?A...s..
	0x83, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x06, 0x19, 0x00, 0x00, 0x04, 0x00,   // .#..............
	0xFB, 0x54, 0x84, 0xE3, 0xA4, 0x41, 0x59, 0x4F, 0xA5, 0xDC, 0x25, 0x08, 0x0E, 0x35, 0x47, 0x30,   // T.AYO%..5G0
	0x9B, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x06, 0x19, 0x00, 0x00, 0x04, 0x00,   // .#..............
	0x60, 0x5A, 0x5A, 0x2D, 0x40, 0x30, 0xBF, 0x48, 0xBE, 0xB0, 0xFC, 0xD7, 0x70, 0xC2, 0x0C, 0xE0,   // `ZZ-@0Hp.
	0xB4, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // #..............
	0x83, 0x6D, 0x77, 0x9F, 0x56, 0x71, 0xB2, 0x45, 0x8A, 0x5C, 0x35, 0x9B, 0x9C, 0x9F, 0x22, 0xA3,   // .mw.VqE.\5..."
	0xD4, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // #..............
	0x99, 0x7C, 0xE9, 0x58, 0x77, 0xF3, 0xF1, 0x4E, 0x81, 0xD5, 0x4A, 0xD5, 0x52, 0x2B, 0x5F, 0xD8,   // .|XwN.JR+_
	0xF6, 0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // #..............
	0x44, 0x75, 0x10, 0xA9, 0xA0, 0xF4, 0x53, 0x40, 0xA9, 0x6A, 0x14, 0x79, 0xAB, 0xDE, 0xF9, 0x12,   // Du..S@j.y.
	0x06, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // .$..............
	0x51, 0x17, 0x9E, 0x7B, 0xDA, 0xA8, 0x75, 0x4F, 0x95, 0x60, 0x5F, 0xAD, 0xFE, 0x3D, 0x8E, 0x38,   // Q..{ڨuO.`_=.8
	0x27, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // '$..............
	0x57, 0x8A, 0x91, 0xCD, 0x1B, 0xA4, 0x82, 0x4C, 0x8D, 0xCE, 0x1A, 0x53, 0x8E, 0x22, 0x1A, 0x83,   // W....L..S."..
	0x39, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // 9$..............
	0x88, 0x22, 0xC4, 0xE0, 0x0C, 0x98, 0x88, 0x47, 0xA0, 0x14, 0xC0, 0x80, 0xD2, 0xE1, 0x92, 0x6E,   // ."...G....n
	0x59, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // Y$..............
	0x55, 0x23, 0x10, 0x3C, 0x27, 0xD0, 0xC6, 0x42, 0xAD, 0x23, 0x2E, 0x7E, 0xF8, 0xA0, 0x25, 0x85,   // U#.<'B#.~.%.
	0x6E, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // n$..............
	0x21, 0x11, 0x11, 0x73, 0x38, 0x56, 0xF6, 0x40, 0xBC, 0x11, 0xF1, 0xD7, 0xB0, 0xD6, 0x43, 0x00,   // !..s8V@.װC.
	0x85, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // .$..............
	0x6C, 0xA4, 0x51, 0x7B, 0x04, 0x0C, 0x8F, 0x4E, 0x9A, 0xF4, 0x84, 0x96, 0xCC, 0xA9, 0x0D, 0x5E,   // lQ{...N...̩.^
	0x9B, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // .$..............
	0xB7, 0x38, 0xB8, 0x87, 0xB6, 0x41, 0x90, 0x45, 0x83, 0x18, 0x57, 0x97, 0x95, 0x1D, 0x85, 0x29,   // 8.A.E..W....)
	0xBB, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // $..............
	0xE2, 0xE3, 0x72, 0xE2, 0x2F, 0x73, 0x65, 0x4C, 0xA8, 0xF0, 0x48, 0x47, 0x47, 0xD0, 0xD9, 0x47,   // r/seLHGGG
	0xDD, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // $..............
	0x92, 0xC0, 0xBB, 0x82, 0x50, 0xBC, 0x16, 0x4E, 0x8E, 0x18, 0xB7, 0x4F, 0xC4, 0x86, 0xAE, 0xC3,   // ..P.N..O.
	0xF5, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // $..............
	0xD3, 0x71, 0x15, 0x4B, 0xFB, 0xBA, 0x40, 0x4B, 0x80, 0x87, 0xA9, 0x61, 0xBE, 0x2C, 0xAF, 0x65,   // q.K@K..a,e
	0x19, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // .%..............
	0x92, 0x73, 0xE6, 0x2D, 0xA7, 0xB7, 0x2A, 0x46, 0xB1, 0xCA, 0x10, 0x8D, 0xD1, 0x89, 0xF5, 0x88,   // .s-*F....
	0x3F, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // ?%..............
	0x82, 0xFC, 0x1A, 0x3F, 0xAC, 0xF8, 0x6C, 0x4F, 0x80, 0x05, 0x1D, 0x23, 0x3E, 0x60, 0x6E, 0xEE,   // ..?lO...#>`n
	0x57, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // W%..............
	0x8C, 0xB1, 0x00, 0x53, 0x33, 0x2E, 0xC2, 0x4D, 0x82, 0x91, 0x47, 0xFF, 0xCE, 0xC7, 0x46, 0xDD,   // ..S3.M..GF
	0x79, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // y%..............
	0xBF, 0x5A, 0x0B, 0xA8, 0xAD, 0x76, 0x8B, 0x42, 0xB0, 0x5D, 0xA4, 0x7D, 0x2D, 0xFF, 0xEE, 0xBF,   // Z.v.B]}-
	0x9D, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // .%..............
	0x01, 0x82, 0x80, 0xFF, 0xC6, 0xFE, 0xD4, 0x4F, 0xAE, 0x16, 0xAB, 0xBD, 0xDA, 0xDE, 0x57, 0x06,   // ...O.W.
	0xB7, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // %..............
	0x05, 0xAB, 0xF2, 0x43, 0x87, 0x7C, 0x56, 0x4D, 0xB2, 0x7C, 0x44, 0xD0, 0xF9, 0xA3, 0xDA, 0xBD,   // .C.|VM|Dڽ
	0xD7, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // %..............
	0x65, 0x8E, 0x86, 0xEC, 0xDF, 0xFA, 0x59, 0x47, 0xB2, 0x3E, 0x93, 0xFE, 0x37, 0xF2, 0xCC, 0x29,   // e..YG>.7)
	0xF5, 0x25, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // %..............
	0xEA, 0x50, 0xDB, 0xE4, 0xA1, 0xBD, 0x66, 0x45, 0xB0, 0x47, 0x0C, 0xA5, 0x0A, 0xBC, 0x6F, 0x07,   // P䡽fEG..o.
	0x20, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   //  &..............
	0x14, 0xF8, 0xF4, 0x0D, 0x57, 0x3F, 0x8B, 0x4B, 0x9A, 0x9D, 0xFD, 0xDA, 0xDC, 0xD6, 0x9F, 0xAC,   // ..W?.K...
	0x39, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // 9&..............
	0x09, 0xE5, 0x2E, 0xAE, 0x34, 0x1B, 0xC0, 0x41, 0xAC, 0xB7, 0x6D, 0x46, 0x50, 0x16, 0x89, 0x15,   // ..4.AmFP...
	0x4D, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // M&..............
	0x08, 0xED, 0xBB, 0x46, 0x7B, 0x9C, 0xFC, 0x48, 0xA6, 0x14, 0x95, 0x25, 0x05, 0x73, 0xF4, 0xEA,   // .F{.H..%.s
	0x62, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // b&..............
	0x05, 0xD6, 0xB6, 0x1C, 0xB3, 0x11, 0x14, 0x4E, 0xBB, 0x30, 0xDA, 0x91, 0xC8, 0xE3, 0x98, 0x3A,   // .ֶ...N0..:
	0x79, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // y&..............
	0x80, 0x99, 0x2E, 0xB9, 0xD5, 0xB9, 0x21, 0x48, 0x9C, 0x94, 0x14, 0x0F, 0x63, 0x2F, 0x63, 0x12,   // ...չ!H....c/c.
	0x90, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // .&..............
	0x29, 0x15, 0x04, 0x5A, 0xF8, 0xFE, 0x07, 0x4D, 0xB0, 0x6F, 0xB5, 0x9B, 0x57, 0x3B, 0x32, 0xD2,   // )..Z.Mo.W;2
	0xA7, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // &..............
	0x0D, 0x9A, 0xA0, 0x54, 0x7B, 0xD5, 0x10, 0x4C, 0x8B, 0x69, 0xA8, 0x42, 0xD6, 0x59, 0x0A, 0xD5,   // ...T{.L.iBY.
	0xC0, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // &..............
	0x96, 0x78, 0x53, 0xDB, 0x6F, 0x37, 0xAE, 0x48, 0xA4, 0x92, 0x53, 0xD0, 0x54, 0x77, 0x73, 0xD0,   // .xSo7H.STws
	0xD9, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // &..............
	0x6A, 0x29, 0xA8, 0xE1, 0x37, 0xDB, 0xD1, 0x44, 0x8C, 0xCE, 0x7B, 0xC9, 0x61, 0xD5, 0x9C, 0x54,   // j)7D.{a.T
	0xF5, 0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // &..............
	0xAA, 0xD3, 0x6D, 0xAA, 0xB4, 0xC2, 0xE2, 0x40, 0xA5, 0x44, 0xA6, 0xBB, 0xB3, 0xF5, 0xC3, 0x95,   // m@D.
	0x11, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // .'..............
	0xBF, 0xD6, 0x4E, 0xC0, 0xC8, 0x55, 0x47, 0x4B, 0x9F, 0x8E, 0x5A, 0x1F, 0x31, 0xCE, 0xEE, 0x60,   // NUGK..Z.1`
	0x22, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00,   // "'..............
	0xA2, 0x84, 0x55, 0x9D, 0x85, 0x2D, 0x9A, 0x41, 0x98, 0x2C, 0xA0, 0x08, 0x88, 0xBB, 0x9D, 0xDF,   // .U..-.A.,....
	0x31, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00,   // 1'..............
	0xA0, 0x90, 0x73, 0x19, 0xF6, 0x65, 0x95, 0x4A, 0xBD, 0xC4, 0x55, 0xD5, 0x8A, 0x3B, 0x02, 0x53,   // ..s.e.JU.;.S
	0x51, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00,   // Q'..............
	0xD4, 0xFC, 0x60, 0x88, 0x7B, 0xA7, 0x20, 0x4A, 0x90, 0x45, 0xA1, 0x50, 0xFF, 0x11, 0xD6, 0x09,   // `.{ J.EP..
	0x62, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00,   // b'..............
	0xA3, 0x18, 0x00, 0xA0, 0x0F, 0xF2, 0x32, 0x46, 0xBF, 0x7C, 0x8D, 0xAA, 0x53, 0x51, 0xC9, 0x14,   // ....2F|.SQ.
	0x81, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x05, 0x19, 0x01, 0x00, 0x00, 0x00,   // .'..............
	0xAF, 0x8B, 0x01, 0x10, 0x21, 0xCE, 0x60, 0x40, 0x80, 0xBD, 0x47, 0xFE, 0x74, 0xED, 0x4D, 0xAB,   // ...!`@.GtM
	0x9C, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00,   // .'..............
	0x48, 0x18, 0xDB, 0x18, 0xE0, 0x12, 0x67, 0x41, 0xB9, 0xD7, 0xDA, 0x7F, 0xCD, 0xA5, 0x07, 0xDB,   // H...gA.ͥ.
	0xC5, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00,   // '..............
	0xEC, 0x1B, 0x8E, 0x45, 0x7A, 0x83, 0xF6, 0x45, 0xB9, 0xD5, 0x92, 0x5E, 0xD5, 0xD2, 0x99, 0xDE,   // ..Ez.E.^.
	0xEC, 0x27, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00,   // '..............
	0xE7, 0x97, 0x49, 0xE1, 0x0A, 0x80, 0xF7, 0x4C, 0xAD, 0x10, 0xDE, 0x4B, 0x45, 0xB5, 0x78, 0xDB,   // .I..L.KEx
	0x01, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00,   // .(..............
	0x6D, 0xCD, 0x8B, 0xA9, 0x43, 0x53, 0x03, 0x46, 0x8A, 0xFE, 0x59, 0x08, 0xE4, 0x61, 0x11, 0x12,   // m.CS.F.Y.a..
	0x18, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00,   // .(..............
	0xC1, 0x45, 0xF2, 0xEB, 0xA8, 0x29, 0xAF, 0x4D, 0x9C, 0xB1, 0x38, 0xDF, 0xC6, 0x08, 0xA8, 0xC8,   // E)M.8.
	0x2F, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x05, 0x19, 0x00, 0x00, 0x00, 0x00,   // /(..............
	0x38, 0x32, 0x1C, 0xFE, 0x2A, 0x43, 0xA1, 0x43, 0x8E, 0x25, 0x97, 0xE7, 0xD1, 0xEF, 0x10, 0xF3,   // 82.*CC.%..
	0x48, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // H(..............
	0x6A, 0x45, 0xEE, 0xFF, 0x87, 0xCD, 0x90, 0x43, 0x8E, 0x07, 0x16, 0x14, 0x6C, 0x67, 0x2F, 0xD0,   // jE..C....lg/
	0x59, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // Y(..............
	0x4F, 0xB7, 0x78, 0xDB, 0x1C, 0xEF, 0x92, 0x48, 0xAB, 0xFE, 0x1E, 0x66, 0xB8, 0x23, 0x1D, 0xF6,   // Ox..H.f#.
	0x6E, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // n(..............
	0x64, 0x8A, 0x55, 0x78, 0x19, 0xDC, 0xFE, 0x43, 0xA0, 0xD0, 0x80, 0x75, 0xB2, 0xA3, 0x70, 0xA3,   // d.Ux.C..up
	0x90, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // .(..............
	0x1D, 0x6A, 0x2C, 0xC7, 0x52, 0xF2, 0x7E, 0x4E, 0xBD, 0xD1, 0x3F, 0xCA, 0x34, 0x2A, 0xCB, 0x35,   // .j,R~N?4*5
	0xA3, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // (..............
	0xB5, 0x87, 0x8D, 0xE5, 0x26, 0x81, 0x80, 0x45, 0x80, 0xFB, 0x86, 0x1B, 0x22, 0xF7, 0x92, 0x96,   // ..&..E..."..
	0xC4, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // (..............
	0xC7, 0x91, 0xB4, 0xCA, 0x18, 0xA9, 0x60, 0x4F, 0xB5, 0x02, 0xDA, 0xB7, 0x5E, 0x33, 0x4F, 0x40,   // ..`O.ڷ^3O@
	0xE5, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // (..............
	0x3D, 0xE6, 0x6C, 0x09, 0xAC, 0x4F, 0xA9, 0x48, 0x82, 0xA9, 0x61, 0xAE, 0x9E, 0x80, 0x0E, 0x5F,   // =l.OH.a..._
	0x08, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0A, 0x06, 0x19, 0x01, 0x00, 0x00, 0x00,   // .)..............
	0x32, 0x2B, 0x94, 0xE9, 0x55, 0x2E, 0x97, 0x41, 0xB0, 0xBD, 0x5F, 0xF5, 0x8C, 0xBA, 0x88, 0x60,   // 2+.U..A_..`
	0x25, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // %)..............
	0x12, 0x82, 0x99, 0xBA, 0x0A, 0x46, 0xDB, 0x44, 0xBF, 0xB5, 0x71, 0xBF, 0x09, 0xD1, 0xC6, 0x8B,   // ....FDq..
	0x40, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // @)..............
	0xD6, 0xEC, 0xDD, 0xC6, 0x54, 0x23, 0x19, 0x4C, 0x90, 0x9B, 0x30, 0x6A, 0x30, 0x58, 0x48, 0x4E,   // T#.L..0j0XHN
	0x6C, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // l)..............
	0xA3, 0xE3, 0xF5, 0xB8, 0x33, 0xED, 0x08, 0x46, 0x81, 0xE1, 0x37, 0xD6, 0xC9, 0xDC, 0xFD, 0x9C,   // 3.F.7.
	0x89, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // .)..............
	0xAF, 0x1A, 0x67, 0x81, 0xD1, 0x79, 0xB1, 0x4E, 0xB0, 0x04, 0x8C, 0xBB, 0xE1, 0x73, 0xAF, 0xEA,   // .g.yN..s
	0xB4, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // )..............
	0x5C, 0x70, 0x3E, 0x11, 0x49, 0xFA, 0xA4, 0x48, 0xBE, 0xEA, 0x7D, 0xD8, 0x79, 0xB4, 0x6B, 0x14,   // \p>.IH}yk.
	0xCB, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // )..............
	0x81, 0x69, 0x6B, 0xC0, 0xFD, 0xD7, 0x35, 0x4A, 0xB7, 0xB4, 0x05, 0x47, 0x42, 0xB7, 0xAF, 0x67,   // .ik5J.GBg
	0xE4, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // )..............
	0x9F, 0xD7, 0x76, 0x74, 0x48, 0x8E, 0xB4, 0x49, 0xAB, 0x63, 0x4D, 0x0B, 0x81, 0x3A, 0x16, 0xE4,   // .vtH.IcM..:.
	0xFD, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // )..............
	0x54, 0x2D, 0xB8, 0x0A, 0xF4, 0x47, 0xCB, 0x4A, 0x81, 0x8C, 0xCC, 0x5B, 0xF0, 0xEC, 0xB6, 0x49,   // T-.GJ..[I
	0x18, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // .*..............
	0x90, 0x85, 0xE8, 0xF7, 0xC7, 0xDF, 0x78, 0x4C, 0xBC, 0xCB, 0x6F, 0x38, 0x65, 0xB9, 0x9D, 0x1A,   // ..xLo8e..
	0x43, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // C*..............
	0x9F, 0x2D, 0x4E, 0xCD, 0x59, 0x50, 0x50, 0x4A, 0xA9, 0x2D, 0x05, 0xD5, 0xBB, 0x12, 0x67, 0xC7,   // .-NYPPJ-.ջ.g
	0x6C, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0B, 0x06, 0x19, 0x00, 0x00, 0x00, 0x00,   // l*..............
	0xC7, 0x52, 0xE9, 0xCD, 0x96, 0x2F, 0x9D, 0x4D, 0x8F, 0x2B, 0x2D, 0x34, 0x9F, 0x64, 0xFC, 0x51,   // R./.M.+-4.dQ
	0x95, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00,   // .*..............
	0x6B, 0x3E, 0x38, 0xA4, 0xDA, 0xDA, 0x3D, 0x42, 0xA4, 0x3D, 0xF2, 0x56, 0x78, 0x42, 0x96, 0x76,   // k>8=B=VxB.v
	0xB3, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00,   // *..............
	0x7B, 0xA0, 0x59, 0xCF, 0x2A, 0x1A, 0xE0, 0x4B, 0xBF, 0xE0, 0x42, 0x3B, 0x58, 0x23, 0xE6, 0x63,   // {.Y*.KB;X#c
	0xD3, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00,   // *..............
	0x7F, 0x33, 0x9C, 0x2B, 0x1D, 0x7A, 0x71, 0x42, 0x90, 0xA3, 0xC6, 0x85, 0x5A, 0x2B, 0x8A, 0x1C,   // .3.+.zqB..Z+..
	0xF7, 0x2A, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00,   // *..............
	0x72, 0xAD, 0x1E, 0x63, 0xAB, 0xA8, 0xF8, 0x4D, 0xBB, 0xDF, 0x37, 0x20, 0x29, 0x98, 0x9B, 0xDD,   // r.cM7 )..
	0x0B, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x05, 0x19, 0x00, 0x01, 0x00, 0x00,   // .+..............
	0x7C, 0x9F, 0xFA, 0xDD, 0x9E, 0xF0, 0xB9, 0x40, 0x8C, 0x1A, 0xBE, 0x87, 0x7A, 0x9A, 0x7F, 0x4B,   // |..@...z..K
	0x23, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // #+..............
	0x56, 0x11, 0xFB, 0x7A, 0x1D, 0x2C, 0xFC, 0x40, 0xB2, 0x60, 0xAA, 0xB7, 0x44, 0x2B, 0x62, 0xFE,   // V.z.,@`D+b
	0x3B, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0D, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // ;+..............
	0xD4, 0x42, 0x25, 0xAD, 0x54, 0x91, 0x6D, 0x4C, 0x8A, 0x44, 0x30, 0xF1, 0x1E, 0xE9, 0x69, 0x89,   // B%T.mL.D0.i.
	0x5F, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // _+..............
	0xD0, 0xE3, 0x01, 0x24, 0x0A, 0xC5, 0x58, 0x4B, 0x87, 0xB2, 0x7E, 0x79, 0x4B, 0x7D, 0x26, 0x07,   // .$.XK.~yK}&.
	0x7C, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // |+..............
	0x90, 0x4D, 0xAF, 0xC1, 0xBC, 0xD1, 0xCA, 0x44, 0x85, 0xD4, 0x00, 0x3B, 0xA3, 0x3D, 0xB3, 0xB9,   // .MD..;=
	0xA9, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // +..............
	0x0A, 0x49, 0x98, 0x81, 0xD0, 0xAD, 0xB2, 0x47, 0xB3, 0xBA, 0x31, 0x6B, 0x12, 0xD6, 0x47, 0xB4,   // .I..ЭG1k.G
	0xC8, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0E, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // +..............
	0x20, 0xE2, 0xB6, 0x68, 0x09, 0xCF, 0x6B, 0x46, 0x92, 0xD3, 0x45, 0xCD, 0x96, 0x4B, 0x95, 0x09,   //  h.kF.E.K..
	0xF7, 0x2B, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // +..............
	0x77, 0xEF, 0x09, 0xFD, 0x47, 0x56, 0xFF, 0x4E, 0x80, 0x9C, 0xAF, 0x2B, 0x64, 0x65, 0x9A, 0x45,   // w.GVN..+de.E
	0x16, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // .,..............
	0x6B, 0x17, 0xEF, 0x01, 0x0D, 0x3E, 0x2A, 0x42, 0xB4, 0xF8, 0x4E, 0xA8, 0x80, 0x03, 0x5E, 0x8F,   // k...>*BN..^.
	0x45, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0F, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // E,..............
	0x5C, 0x51, 0x72, 0xF7, 0x87, 0x0E, 0xD5, 0x48, 0xA6, 0x76, 0xE6, 0x96, 0x2C, 0x3E, 0x11, 0x95,   // \Qr..Hv.,>..
	0x65, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // e,..............
	0xD9, 0x8B, 0x8B, 0xA7, 0x17, 0x80, 0xF5, 0x4D, 0xB8, 0x6A, 0x09, 0xF7, 0x56, 0xAF, 0xFA, 0x7C,   // ....Mj.V|
	0x84, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // .,..............
	0xF3, 0x8C, 0xA1, 0xCD, 0x96, 0xC1, 0xAD, 0x46, 0xB2, 0x89, 0x60, 0xC0, 0x72, 0x86, 0x99, 0x94,   // ..F.`r...
	0x9F, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // .,..............
	0xB9, 0x1F, 0x53, 0x68, 0x11, 0x55, 0x89, 0x49, 0x97, 0xBE, 0xD1, 0x1A, 0x0F, 0x55, 0x63, 0x3F,   // .Sh.U.I...Uc?
	0xC2, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // ,..............
	0x3D, 0x2B, 0x0E, 0x62, 0xE7, 0x09, 0xFD, 0x42, 0x80, 0x2A, 0x17, 0xA1, 0x36, 0x52, 0xFE, 0x7A,   // =+.b.B.*.6Rz
	0xE2, 0x2C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x11, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // ,..............
	0x1B, 0xE6, 0x82, 0x74, 0x89, 0xC5, 0x7F, 0x4B, 0x8E, 0xCC, 0x46, 0xD4, 0x55, 0xAC, 0x3B, 0x87,   // ..t..K.FU;.
	0x04, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // .-..............
	0x1C, 0x85, 0x26, 0x8A, 0x7E, 0x1C, 0xD3, 0x48, 0xA6, 0x87, 0xFB, 0xCA, 0x9B, 0x9A, 0xC1, 0x6B,   // ..&.~.H...k
	0x26, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x04, 0x05, 0x00, 0x00, 0x00, 0x00,   // &-..............
	0x60, 0x3D, 0x64, 0xD3, 0x42, 0x0C, 0x2D, 0x41, 0xA7, 0xD6, 0x52, 0xE6, 0x63, 0x53, 0x27, 0xF6,   // `=dB.-ARcS'
	0x54, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00,   // T-..............
	0x83, 0x1C, 0xFD, 0x95, 0xF5, 0x7D, 0x4A, 0x49, 0xBE, 0x8B, 0x13, 0x00, 0xE1, 0xC9, 0xD1, 0xCD,   // ...}JI...
	0x73, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00,   // s-..............
	0xC7, 0x86, 0x54, 0x7D, 0x20, 0xE1, 0x71, 0x47, 0xB7, 0xF1, 0x7B, 0x56, 0xC6, 0xD3, 0x17, 0x0C,   // .T} qG{V..
	0x9A, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00,   // .-..............
	0x41, 0xEC, 0xF5, 0xF0, 0x55, 0x0D, 0x32, 0x47, 0xAF, 0x02, 0x44, 0x0A, 0x44, 0xA3, 0xCF, 0x0F,   // AU.2G.D.D.
	0xC2, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x13, 0x05, 0x05, 0x00, 0x00, 0x00, 0x00,   // -..............
	0xBE, 0xA2, 0x43, 0xB7, 0xD4, 0x68, 0xD3, 0x4D, 0xAF, 0x32, 0x92, 0x42, 0x5B, 0x7B, 0xB6, 0x23,   // ChM2.B[{#
	0xDF, 0x2D, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // -..............
	0x44, 0x13, 0x09, 0x00, 0xA4, 0x1E, 0x37, 0x4F, 0xB7, 0x89, 0x01, 0x75, 0x0B, 0xA6, 0x98, 0x8C,   // D....7O..u...
	0x04, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // ................
	0xA4, 0x6B, 0xDB, 0x21, 0x7B, 0x9A, 0x14, 0x4A, 0x9E, 0x29, 0x64, 0xA6, 0x0C, 0x59, 0x30, 0x1D,   // k!{..J.)d.Y0.
	0x26, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // &...............
	0x4E, 0x04, 0xCA, 0xB3, 0x58, 0xA3, 0x68, 0x4D, 0x98, 0x83, 0xAA, 0xA2, 0x94, 0x1A, 0xCA, 0x99,   // N.ʳXhM.....
	0x48, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x14, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // H...............
	0x1B, 0x34, 0xBF, 0x3D, 0x6C, 0x5F, 0xA7, 0x4F, 0xB9, 0x36, 0x69, 0x9D, 0xCE, 0x9E, 0x26, 0x3F,   // .4=l_O6i..&?
	0x68, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // h...............
	0xF4, 0x33, 0x44, 0x7B, 0xE7, 0xB1, 0x88, 0x47, 0x89, 0x5A, 0xC4, 0x53, 0x78, 0xD3, 0x82, 0x53,   // 3D{.G.ZSx.S
	0x87, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // ................
	0x79, 0x67, 0xC5, 0x21, 0x49, 0xB4, 0x20, 0x4D, 0xAD, 0xFC, 0xEE, 0xCE, 0x0E, 0x1A, 0xD7, 0x4B,   // yg!I M..K
	0xA9, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // ...............
	0x0F, 0x1B, 0x5A, 0x2B, 0xAB, 0xA5, 0x54, 0x4C, 0xAC, 0x2F, 0xA6, 0xD9, 0x48, 0x24, 0xA2, 0x83,   // ..Z+TL/H$.
	0xC8, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // ...............
	0x10, 0x54, 0x1C, 0x8C, 0x39, 0x9F, 0x05, 0x48, 0x8C, 0x9D, 0x63, 0xA0, 0x77, 0x06, 0x35, 0x8F,   // .T..9..H..c.w.5.
	0xE7, 0x2E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // ...............
	0x6E, 0xAF, 0xD9, 0x43, 0x86, 0x5E, 0xE8, 0x4B, 0xA7, 0x97, 0xD0, 0x72, 0xA0, 0x46, 0x89, 0x6C,   // nC.^K.r.F.l
	0x04, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // ./..............
	0xE7, 0x08, 0x9C, 0xE4, 0x82, 0xDA, 0xF8, 0x42, 0xBD, 0xE2, 0xB5, 0x70, 0xFB, 0xCA, 0xE7, 0x6C,   // ...Bpl
	0x1E, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // ./..............
	0x22, 0xEF, 0xC5, 0x61, 0x4F, 0xF1, 0x53, 0x45, 0xA8, 0x24, 0xC4, 0xB3, 0x1E, 0x84, 0xB1, 0x00,   // "aOSE$ĳ...
	0x53, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x15, 0x06, 0x05, 0x00, 0x00, 0x00, 0x00,   // S/..............
	0x44, 0x7C, 0x94, 0xBA, 0x9D, 0xD1, 0x86, 0x47, 0xB6, 0xAE, 0x22, 0x77, 0x0B, 0xC9, 0x4C, 0x54,   // D|...G"w.LT
	0x86, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x16, 0x06, 0x05, 0x00, 0x01, 0x00, 0x00,   // ./..............
	0x06, 0x16, 0x3D, 0x4F, 0xEA, 0x3F, 0x01, 0x4C, 0xBE, 0x3C, 0x8D, 0x67, 0x1C, 0x40, 0x1E, 0x3B,   // ..=O?.L<.g.@.;
	0xAD, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // /..............
	0xC2, 0x2D, 0x68, 0x2C, 0x68, 0x8B, 0x63, 0x4F, 0xA1, 0x65, 0xAE, 0x29, 0x1D, 0x4C, 0xF1, 0x38,   // -h,h.cOe).L8
	0xC4, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // /..............
	0x08, 0xFF, 0xD8, 0xCF, 0xD7, 0xC0, 0x2B, 0x45, 0x9F, 0x60, 0xEF, 0x5C, 0x70, 0xC3, 0x20, 0x94,   // .+E.`\p .
	0xDD, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // /..............
	0x50, 0x49, 0xF5, 0xD4, 0xF2, 0x26, 0xB4, 0x4F, 0xBA, 0x21, 0xFF, 0xAB, 0x16, 0xAF, 0xCA, 0xDE,   // PI&O!.
	0xF6, 0x2F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x17, 0x04, 0x19, 0x00, 0x00, 0x00, 0x00,   // /..............
	0x72, 0xE8, 0xE7, 0x8C, 0x8C, 0x18, 0x98, 0x4B, 0x9D, 0x90, 0xF8, 0xF9, 0x0B, 0x7A, 0xAD, 0x02,   // r....K...z.
	0x11, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // .0..............
	0x70, 0xD4, 0xE5, 0xCE, 0x3B, 0x6E, 0xCC, 0x4F, 0x8C, 0x2B, 0xD1, 0x74, 0x28, 0x56, 0x8A, 0x9F,   // p;nO.+t(V..
	0x24, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // $0..............
	0xB8, 0xD0, 0x47, 0x89, 0x3B, 0xC3, 0xE1, 0x43, 0x8C, 0x56, 0x9B, 0x67, 0x4C, 0x05, 0x28, 0x32,   // G.;C.V.gL.(2
	0x36, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // 60..............
	0x39, 0x66, 0x6B, 0xCA, 0xD6, 0x4A, 0xAE, 0x40, 0xA5, 0x75, 0x14, 0xDE, 0xE0, 0x7F, 0x64, 0x30,   // 9fkJ@u..d0
	0x49, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // I0..............
	0x40, 0x96, 0xED, 0x09, 0x20, 0xF0, 0x0A, 0x40, 0xAC, 0xD8, 0xD7, 0xD8, 0x67, 0xDF, 0xD9, 0xC2,   // @.. .@g
	0x5E, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // ^0..............
	0x49, 0x4E, 0x3D, 0xEF, 0x3D, 0xA5, 0x81, 0x4D, 0xA2, 0xB1, 0x2C, 0xA6, 0xC2, 0x55, 0x6B, 0x2C,   // IN==.M,Uk,
	0x72, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // r0..............
	0x5C, 0x6F, 0x58, 0xAB, 0x56, 0x52, 0x32, 0x46, 0x96, 0x2F, 0xFE, 0xFD, 0x8B, 0x49, 0xE6, 0xF4,   // \oXVR2F./.I
	0x86, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // .0..............
	0x92, 0xC1, 0xB7, 0xEC, 0xAB, 0x73, 0xED, 0x4D, 0xAC, 0xF4, 0x23, 0x99, 0xB0, 0x95, 0xD0, 0xCC,   // .sM#..
	0x9A, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // .0..............
	0x1D, 0x3B, 0x59, 0x45, 0xB1, 0xDF, 0x91, 0x4E, 0xBB, 0xFB, 0x2D, 0x5D, 0x0C, 0xE2, 0x22, 0x7A,   // .;YE.N-]."z
	0xAE, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // 0..............
	0x60, 0x77, 0x32, 0x6F, 0x5C, 0x8C, 0x7C, 0x41, 0x9B, 0x61, 0x83, 0x6A, 0x98, 0x28, 0x7E, 0x0C,   // `w2o\.|A.a.j.(~.
	0xC5, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // 0..............
	0xF7, 0x3F, 0x13, 0xDF, 0x14, 0xBF, 0x95, 0x4F, 0xAF, 0xE3, 0x7B, 0x48, 0xE7, 0xE3, 0x31, 0xEF,   // ?...O{H1
	0xE3, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // 0..............
	0x61, 0xBF, 0xC7, 0x5D, 0xC9, 0x5E, 0x96, 0x49, 0x9C, 0xCB, 0xDF, 0x80, 0x6A, 0x2D, 0x0E, 0xFE,   // a]^.I..j-.
	0xFB, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // 0..............
	0x75, 0x4F, 0x0C, 0xB5, 0x9B, 0x59, 0xE8, 0x43, 0x8D, 0xCD, 0x10, 0x81, 0xA7, 0x96, 0x72, 0x41,   // uO..YC....rA
	0x18, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // .1..............
	0x87, 0x9E, 0x50, 0xEA, 0xA1, 0x07, 0x45, 0x4A, 0x9E, 0xDC, 0xEB, 0xA5, 0xA3, 0x9F, 0x36, 0xAF,   // ..P.EJ.륣.6
	0x2E, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // .1..............
	0x78, 0xA6, 0xA2, 0x9D, 0x6B, 0xFB, 0x67, 0x4E, 0xAB, 0x84, 0x60, 0xDD, 0x6A, 0x9C, 0x81, 0x9A,   // x.kgN.`j...
	0x50, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // P1..............
	0x05, 0x61, 0x23, 0x92, 0x67, 0xBB, 0x4F, 0x49, 0x94, 0xC7, 0x7F, 0x7A, 0x60, 0x79, 0x29, 0xBD,   // .a#.gOI..z`y)
	0x65, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // e1..............
	0x9C, 0x38, 0x58, 0xE5, 0xC3, 0x83, 0x29, 0x4B, 0xAD, 0xFE, 0x5E, 0x4D, 0x7F, 0x46, 0xC3, 0x58,   // .8X.)K^M.FX
	0x7F, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // .1..............
	0xFF, 0x33, 0xD8, 0x9E, 0x92, 0x4F, 0x36, 0x4F, 0xB3, 0x70, 0x86, 0x83, 0xA4, 0xF1, 0x32, 0x75,   // 3..O6Op..2u
	0x95, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // .1..............
	0xE7, 0x82, 0x08, 0x2D, 0xE7, 0xA4, 0x3B, 0x42, 0x8C, 0xCC, 0x70, 0xD9, 0x1E, 0x01, 0x58, 0xB1,   // ..-;B.p..X
	0xB0, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x18, 0x04, 0x05, 0x00, 0x00, 0x01, 0x00,   // 1..............
	0x2C, 0x62, 0xE7, 0x6E, 0xD8, 0x18, 0x05, 0x40, 0x9F, 0xB7, 0x92, 0xDB, 0x64, 0x4A, 0x27, 0x9B,   // ,bn..@..dJ'.
	0xC1, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // 1..............
	0x52, 0x1D, 0x46, 0xF7, 0x2B, 0x7C, 0xB2, 0x43, 0x87, 0x44, 0xEA, 0x95, 0x8E, 0x0B, 0xD0, 0x9A,   // R.F+|C.D....
	0xD4, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // 1..............
	0x40, 0x80, 0x0B, 0xA3, 0x8A, 0xD6, 0x3F, 0x42, 0xB0, 0xB5, 0x9C, 0xE2, 0x92, 0xEA, 0x5A, 0x8F,   // @...?B..Z.
	0xE6, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // 1..............
	0xE3, 0x11, 0x9F, 0x1B, 0x5C, 0xC8, 0x1B, 0x4E, 0xBB, 0x29, 0x87, 0x9A, 0xD2, 0xC9, 0x09, 0xE3,   // ...\.N)...
	0xFB, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // 1..............
	0x6B, 0x1C, 0x98, 0xDC, 0x8E, 0xFC, 0x0F, 0x42, 0xAA, 0x43, 0xF8, 0xF3, 0x3E, 0x5C, 0x09, 0x23,   // k....BC>\.#
	0x0C, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // .2..............
	0xE6, 0xF3, 0xE1, 0xEF, 0xA2, 0xAE, 0x44, 0x41, 0xA2, 0x08, 0x32, 0xAA, 0x87, 0x2B, 0x65, 0x45,   // DA.2.+eE
	0x1E, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // .2..............
	0xFA, 0x3A, 0x1C, 0x77, 0xC5, 0x50, 0x3F, 0x44, 0xB1, 0x51, 0xFF, 0x25, 0x46, 0xD8, 0x63, 0xA0,   // :.wP?DQ%Fc.
	0x32, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // 22..............
	0x49, 0x26, 0x76, 0x8C, 0xD1, 0x97, 0x53, 0x49, 0xAD, 0x27, 0xB7, 0xE2, 0xC2, 0x5B, 0x97, 0x2E,   // I&v..SI'[..
	0x46, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // F2..............
	0x9C, 0xDA, 0x22, 0xB3, 0xE2, 0xA2, 0x58, 0x40, 0x9E, 0x4E, 0xF5, 0x9A, 0x69, 0x70, 0xBD, 0x69,   // ."X@.N.ipi
	0x5D, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // ]2..............
	0x4A, 0x12, 0x5D, 0x4A, 0x20, 0xE6, 0xBA, 0x44, 0xB6, 0xFF, 0x65, 0x89, 0x61, 0xB3, 0x3B, 0x9A,   // J.]J De.a;.
	0x7B, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // {2..............
	0xD1, 0x28, 0x7A, 0x42, 0x7C, 0xD1, 0xBF, 0x4A, 0xB7, 0x17, 0x32, 0xC7, 0x80, 0xBA, 0x6F, 0x07,   // (zB|ѿJ.2.o.
	0x93, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // .2..............
	0xF1, 0x9F, 0xC7, 0x00, 0x50, 0x68, 0x3D, 0x44, 0xBF, 0x61, 0x71, 0xCD, 0xE0, 0xDE, 0x30, 0x5F,   // ..Ph=Daq0_
	0xB0, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // 2..............
	0x38, 0xFB, 0x3A, 0xB1, 0x79, 0xCD, 0xE5, 0x4A, 0x9F, 0x7F, 0xEE, 0xD0, 0x58, 0xD7, 0x50, 0xCA,   // 8:yJ..XP
	0xC6, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // 2..............
	0x0E, 0xC1, 0x3A, 0xE1, 0xD0, 0x75, 0xFF, 0x4A, 0xA0, 0xCD, 0x76, 0x49, 0x82, 0xCF, 0x54, 0x1C,   // .:uJ.vI.T.
	0xDB, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // 2..............
	0xF0, 0xFA, 0x4E, 0xAC, 0x1F, 0xF8, 0x61, 0x4F, 0xBD, 0xF7, 0xEA, 0x32, 0xB0, 0x2A, 0xB1, 0x17,   // N.aO2*.
	0xF1, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // 2..............
	0xC6, 0xB1, 0xF5, 0xD9, 0x86, 0x53, 0x5A, 0x49, 0x88, 0xF9, 0x9A, 0xD6, 0xB4, 0x1A, 0xC9, 0xB3,   // Ʊ.SZI..ִ.ɳ
	0x0C, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x19, 0x05, 0x05, 0x00, 0x00, 0x02, 0x00,   // .3..............
	0xE2, 0x38, 0xB5, 0x44, 0x34, 0xFB, 0x32, 0x47, 0x81, 0xE4, 0x64, 0x4C, 0x17, 0xD2, 0xE7, 0x46,   // 8D42G.dL.F
	0x1D, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // .3..............
	0xA0, 0xBF, 0x73, 0x93, 0xB3, 0x97, 0x87, 0x45, 0xAB, 0x73, 0x30, 0x93, 0x44, 0x61, 0xD5, 0x5C,   // .s...Es0.Da.
	0x3E, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // >3..............
	0xB4, 0x6E, 0x28, 0xAA, 0x6F, 0x55, 0xEB, 0x4E, 0x96, 0x7C, 0xC1, 0xB7, 0x71, 0xB7, 0x67, 0x3E,   // n(oUN.|qg>
	0x5E, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // ^3..............
	0x56, 0x82, 0xCC, 0x7C, 0xAA, 0xFB, 0xC6, 0x49, 0xB2, 0xA9, 0xF5, 0xAF, 0xB4, 0x25, 0x7C, 0xD2,   // V.|I%|
	0x7F, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // .3..............
	0x17, 0xFE, 0x3D, 0xC5, 0x00, 0xCC, 0x67, 0x49, 0xB1, 0x88, 0xA0, 0x88, 0xA9, 0x65, 0x49, 0x4D,   // .=.gI...eIM
	0xA2, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // 3..............
	0x7D, 0xA8, 0x16, 0x28, 0xED, 0xE1, 0x97, 0x40, 0xB3, 0x11, 0xE2, 0x34, 0x1C, 0x57, 0xB1, 0x79,   // }.(.@.4.Wy
	0xC1, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // 3..............
	0x08, 0xF9, 0xC0, 0x67, 0x4F, 0x18, 0x64, 0x4F, 0x82, 0x50, 0x12, 0xDB, 0x79, 0x7A, 0xB3, 0xC3,   // .gO.dO.P.yz
	0xE1, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // 3..............
	0x7A, 0x4E, 0xCE, 0x7B, 0x80, 0xDD, 0x82, 0x46, 0x98, 0xFA, 0xF9, 0x93, 0x72, 0x58, 0x03, 0xD2,   // zN{..F..rX.
	0x03, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // .4..............
	0x0A, 0x0C, 0xC1, 0x1E, 0xF6, 0x54, 0x3E, 0x45, 0xB8, 0x5A, 0x6F, 0xA1, 0xBB, 0xFE, 0xA9, 0xB7,   // ...T>EZo
	0x25, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // %4..............
	0xBF, 0xB5, 0xD2, 0x87, 0x7B, 0xD4, 0xFB, 0x41, 0xAF, 0x62, 0x71, 0xC3, 0x82, 0xF5, 0xCC, 0x85,   // .{Abq..
	0x4A, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // J4..............
	0xA9, 0x50, 0xFE, 0x3C, 0x03, 0x0E, 0x29, 0x4B, 0x97, 0x54, 0x9F, 0x19, 0x3F, 0x07, 0xB7, 0x1F,   // P<..)K.T..?..
	0x76, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // v4..............
	0x57, 0x9E, 0xE4, 0x39, 0x68, 0xAE, 0xE3, 0x4E, 0xB0, 0x98, 0x26, 0x48, 0x0D, 0xF3, 0xDA, 0x96,   // W.9hN.&H..
	0x9C, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // .4..............
	0x17, 0x21, 0xAA, 0x15, 0x79, 0x8F, 0xA8, 0x49, 0x83, 0x17, 0x75, 0x30, 0x26, 0xD6, 0xA0, 0x54,   // .!.y.I..u0&.T
	0xC7, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // 4..............
	0x0E, 0xD6, 0xBF, 0xCF, 0x5F, 0x0B, 0x7D, 0x42, 0x91, 0x7C, 0xA4, 0xDF, 0x42, 0xA8, 0x0E, 0x44,   // .ֿ_.}B.|B.D
	0xEB, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // 4..............
	0x81, 0xCC, 0x12, 0x70, 0x87, 0x88, 0xE9, 0x42, 0xB1, 0x7D, 0x4E, 0x5E, 0x42, 0x76, 0x0F, 0x0D,   // ..p..B}N^Bv..
	0x0F, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // .5..............
	0xB6, 0x7E, 0x9C, 0xDE, 0x85, 0x5A, 0x0D, 0x42, 0x97, 0x03, 0xFF, 0xF1, 0x1B, 0xDD, 0x4D, 0x43,   // ~..Z.B...MC
	0x38, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1A, 0x05, 0x05, 0x00, 0x01, 0x00, 0x00,   // 85..............
	0x0C, 0xFC, 0xC0, 0x67, 0xBA, 0xDE, 0x1B, 0x40, 0xBF, 0x8B, 0x9C, 0x8A, 0xD8, 0x39, 0x58, 0x04,   // .g.@...9X.
	0x57, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // W5..............
	0x36, 0x5D, 0xE6, 0xC3, 0x1F, 0x14, 0x2F, 0x4D, 0xA3, 0x03, 0xA8, 0x42, 0xEE, 0x75, 0x6A, 0x29,   // 6]../M.Buj)
	0x6A, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // j5..............
	0xCB, 0xBC, 0xAA, 0x9C, 0xB1, 0x61, 0x4B, 0x4B, 0x8B, 0xEC, 0xD1, 0x0A, 0x3C, 0x3A, 0xC2, 0xCE,   // ˼.aKK..<:
	0x7C, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // |5..............
	0x6E, 0xEA, 0x14, 0xE9, 0xFA, 0xA5, 0x39, 0x44, 0xA3, 0x94, 0xA9, 0xBB, 0x32, 0x93, 0xCA, 0x09,   // n.9D.2..
	0x8E, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // .5..............
	0x59, 0xCE, 0xCA, 0xD8, 0xD2, 0x33, 0xC7, 0x4A, 0x9B, 0x1B, 0x9B, 0x72, 0x33, 0x9C, 0x51, 0xC8,   // Y3J...r3.Q
	0xA2, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // 5..............
	0x65, 0x92, 0x9D, 0xEC, 0x1E, 0x9D, 0xD0, 0x4E, 0x83, 0x8A, 0xCD, 0xC2, 0x0F, 0x25, 0x51, 0xA1,   // e....N...%Q
	0xB6, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // 5..............
	0xBA, 0x1B, 0x0B, 0xD7, 0x93, 0xB8, 0x44, 0x45, 0x96, 0xE2, 0xB7, 0xA3, 0x18, 0x09, 0x1C, 0x33,   // ...DE.ⷣ...3
	0xCA, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // 5..............
	0x6F, 0x59, 0x50, 0xD4, 0x4D, 0x89, 0xE0, 0x49, 0x96, 0x6A, 0xFD, 0x39, 0xED, 0x4C, 0x4C, 0x64,   // oYPM.I.j9LLd
	0xE1, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // 5..............
	0x97, 0x41, 0x41, 0x4F, 0xC2, 0x0F, 0x01, 0x4C, 0xB6, 0x8A, 0x86, 0xCB, 0xB9, 0xAC, 0x25, 0x4C,   // .AAO..L..˹%L
	0xFF, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // 5..............
	0x10, 0x81, 0x9B, 0x82, 0x6F, 0x0E, 0x49, 0x43, 0xBC, 0xA4, 0x42, 0x80, 0x35, 0x77, 0x78, 0x8D,   // ....o.ICB.5wx.
	0x17, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // .6..............
	0xBC, 0xDA, 0x7D, 0xDA, 0xBE, 0x3F, 0x47, 0x44, 0x9E, 0x01, 0x6A, 0xB7, 0x44, 0x0B, 0x4C, 0xD4,   // }ھ?GD..jD.L
	0x33, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // 36..............
	0x45, 0xCA, 0xBA, 0xCB, 0x6A, 0x55, 0x16, 0x44, 0xAD, 0x03, 0xBD, 0xA5, 0x98, 0xEA, 0xA7, 0xC8,   // EʺjU.D..
	0x50, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // P6..............
	0xCB, 0x06, 0x1A, 0x04, 0xB8, 0xC5, 0x72, 0x47, 0x80, 0x9F, 0x41, 0x6D, 0x03, 0xD1, 0x66, 0x54,   // ...rG..Am.fT
	0x71, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // q6..............
	0xE1, 0x4E, 0xE0, 0x83, 0x8D, 0xFA, 0x6D, 0x43, 0x89, 0x94, 0xD3, 0x1A, 0x86, 0x2C, 0xAB, 0x77,   // N..mC....,w
	0x87, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // .6..............
	0x3D, 0xA2, 0xDF, 0xDE, 0xD1, 0x6E, 0xA6, 0x45, 0x85, 0xDC, 0x63, 0xCA, 0xE0, 0x54, 0x6D, 0xE6,   // =nE.cTm
	0xA6, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // 6..............
	0xC1, 0x01, 0xF3, 0x6B, 0x4A, 0xB9, 0xE9, 0x43, 0xBA, 0x31, 0xD4, 0x94, 0x59, 0x8C, 0x47, 0xFB,   // .kJC1.Y.G
	0xBB, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // 6..............
	0xE3, 0xAB, 0x34, 0xB2, 0x57, 0x08, 0x9C, 0x4F, 0xB0, 0x5A, 0x4D, 0xC3, 0x14, 0xF8, 0x55, 0x57,   // 4W..OZM.UW
	0xD1, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // 6..............
	0x21, 0x78, 0x2A, 0xAA, 0x27, 0x18, 0x2C, 0x4C, 0x8F, 0x1D, 0x45, 0x13, 0xA3, 0x4D, 0xDA, 0x97,   // !x*'.,L..E.M.
	0xEB, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // 6..............
	0x20, 0xE6, 0x1F, 0x36, 0xF4, 0x64, 0xB5, 0x41, 0xBA, 0x77, 0x84, 0xF8, 0xE0, 0x79, 0xB1, 0xF7,   //  .6dAw.y
	0x06, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // .7..............
	0xDF, 0xBA, 0x11, 0xBB, 0xAA, 0xD8, 0x0E, 0x47, 0x93, 0x11, 0x20, 0xEA, 0xF8, 0x0F, 0xE5, 0xCC,   // ߺ..G.. .
	0x25, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // %7..............
	0x85, 0x88, 0xC8, 0x0B, 0x8C, 0x71, 0x1D, 0x49, 0x92, 0x1F, 0x6F, 0x21, 0x43, 0x49, 0xE7, 0x9C,   // ....q.I..o!CI.
	0x36, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // 67..............
	0x0C, 0x4D, 0x7C, 0xFC, 0x85, 0x2E, 0xB9, 0x4B, 0xAF, 0xD4, 0x01, 0xED, 0x14, 0x76, 0xB5, 0xE9,   // .M|..K..v
	0x60, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // `7..............
	0x19, 0x66, 0x0F, 0x50, 0x93, 0xEF, 0x75, 0x4B, 0xBC, 0xB4, 0x82, 0x81, 0x99, 0x98, 0xA3, 0xCA,   // .f.P.uK....
	0x84, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1B, 0x06, 0x05, 0x00, 0x00, 0x03, 0x00,   // .7..............
	0xEB, 0xCE, 0x9B, 0x9E, 0x36, 0xE7, 0x26, 0x4F, 0x88, 0xDE, 0x76, 0x3F, 0x87, 0xDC, 0xC4, 0x85,   // ..6&O.v?..
	0xA6, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // 7..............
	0xE9, 0x54, 0x78, 0x23, 0xFC, 0x79, 0x97, 0x44, 0xA0, 0xC1, 0xA7, 0x09, 0x69, 0x69, 0x1C, 0x6B,   // Tx#y.D..ii.k
	0xB9, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // 7..............
	0x01, 0xA3, 0xF8, 0xC8, 0xF5, 0x19, 0x32, 0x41, 0x96, 0xCE, 0x2D, 0xE9, 0xD4, 0xAD, 0xBD, 0x33,   // ..2A.-ԭ3
	0xCB, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // 7..............
	0x61, 0xFD, 0x31, 0x31, 0x4F, 0x5E, 0x08, 0x43, 0x8D, 0x6D, 0x62, 0xBE, 0x19, 0x87, 0xC9, 0x2C,   // a11O^.C.mb..,
	0xDF, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // 7..............
	0x5F, 0x8B, 0xDD, 0x85, 0xA4, 0xEA, 0xF3, 0x4A, 0xA6, 0x28, 0xCC, 0xE9, 0xE7, 0x7C, 0x9A, 0x03,   // _..J(|..
	0xF6, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // 7..............
	0x3F, 0xBF, 0xA2, 0x2C, 0x9E, 0x94, 0x6A, 0x44, 0x82, 0xC7, 0xE2, 0x5A, 0x15, 0xEC, 0x78, 0xC4,   // ?,..jD.Z.x
	0x14, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // .8..............
	0xE3, 0xF0, 0x77, 0x17, 0x92, 0x73, 0x98, 0x41, 0x97, 0xEA, 0x8A, 0xE4, 0xDE, 0x6F, 0x63, 0x81,   // w..s.A..oc.
	0x2C, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // ,8..............
	0xCA, 0x4C, 0x3E, 0x9D, 0x72, 0xE1, 0xF1, 0x46, 0xA2, 0xF4, 0x1D, 0x21, 0x07, 0x05, 0x14, 0x44,   // L>.rF.!...D
	0x49, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // I8..............
	0x6E, 0x6C, 0x4C, 0x73, 0xBA, 0xB0, 0x98, 0x42, 0xA8, 0x91, 0x67, 0x17, 0x72, 0xB2, 0xBD, 0x1B,   // nlLs.B.g.r.
	0x5F, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // _8..............
	0x4B, 0xA7, 0x12, 0x69, 0xFB, 0xA5, 0x1A, 0x40, 0xBF, 0xDB, 0x2E, 0x3A, 0xB4, 0x6F, 0x4B, 0x02,   // K.i.@.:oK.
	0x7E, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // ~8..............
	0x8F, 0xF0, 0x5C, 0x5B, 0x1A, 0xB8, 0x1D, 0x43, 0xB0, 0x80, 0x34, 0x50, 0xD8, 0x62, 0x05, 0x65,   // .\[..C.4Pb.e
	0x93, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // .8..............
	0xF3, 0x7D, 0x6D, 0xE0, 0xD0, 0xAA, 0x9D, 0x41, 0x8D, 0xFB, 0x0A, 0xC3, 0x7E, 0x2B, 0xDF, 0x39,   // }mЪ.A..~+9
	0xA9, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // 8..............
	0xFE, 0x34, 0x98, 0x05, 0xEA, 0xA8, 0xFF, 0x4B, 0xB6, 0x7B, 0x4D, 0x00, 0x6B, 0x54, 0x47, 0xD3,   // 4..K{M.kTG
	0xC4, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x1C, 0x06, 0x05, 0x00, 0x00, 0x05, 0x00,   // 8..............
	0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30, 0x32, 0x30, 0x36, 0x2D, 0x35, 0x35, 0x34, 0x2D,   // 03612-00206-554-
	0x30, 0x30, 0x36, 0x37, 0x33, 0x39, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31,   // 006739-03-1033-1
	0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x38, 0x30, 0x32, 0x30, 0x31,   // 7763.0000-280201
	0x38, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D,   // 8.Windows.03612-
	0x30, 0x30, 0x30, 0x39, 0x36, 0x2D, 0x32, 0x30, 0x31, 0x2D, 0x31, 0x34, 0x38, 0x38, 0x35, 0x33,   // 00096-201-148853
	0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30,   // -03-1033-17763.0
	0x30, 0x30, 0x30, 0x2D, 0x32, 0x38, 0x30, 0x32, 0x30, 0x31, 0x38, 0x00, 0x4F, 0x66, 0x66, 0x69,   // 000-2802018.Offi
	0x63, 0x65, 0x32, 0x30, 0x31, 0x30, 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30, 0x32,   // ce2010.03612-002
	0x30, 0x36, 0x2D, 0x32, 0x35, 0x30, 0x2D, 0x35, 0x36, 0x30, 0x36, 0x33, 0x35, 0x2D, 0x30, 0x33,   // 06-250-560635-03
	0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30,   // -1033-17763.0000
	0x2D, 0x32, 0x38, 0x30, 0x32, 0x30, 0x31, 0x38, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32,   // -2802018.Office2
	0x30, 0x31, 0x33, 0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30, 0x32, 0x30, 0x36, 0x2D,   // 013.03612-00206-
	0x34, 0x35, 0x34, 0x2D, 0x31, 0x36, 0x37, 0x32, 0x31, 0x31, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30,   // 454-167211-03-10
	0x33, 0x33, 0x2D, 0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x38,   // 33-17763.0000-28
	0x30, 0x32, 0x30, 0x31, 0x38, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x36,   // 02018.Office2016
	0x00, 0x30, 0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x33, 0x38, 0x35, 0x38, 0x2D, 0x33, 0x36, 0x31,   // .03612-03858-361
	0x2D, 0x39, 0x31, 0x34, 0x30, 0x37, 0x39, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D,   // -914079-03-1033-
	0x31, 0x37, 0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x38, 0x30, 0x32, 0x30,   // 17763.0000-28020
	0x31, 0x38, 0x00, 0x57, 0x69, 0x6E, 0x43, 0x68, 0x69, 0x6E, 0x61, 0x47, 0x6F, 0x76, 0x00, 0x30,   // 18.WinChinaGov.0
	0x33, 0x36, 0x31, 0x32, 0x2D, 0x30, 0x30, 0x32, 0x30, 0x36, 0x2D, 0x36, 0x37, 0x32, 0x2D, 0x33,   // 3612-00206-672-3
	0x30, 0x31, 0x33, 0x37, 0x31, 0x2D, 0x30, 0x33, 0x2D, 0x31, 0x30, 0x33, 0x33, 0x2D, 0x31, 0x37,   // 01371-03-1033-17
	0x37, 0x36, 0x33, 0x2E, 0x30, 0x30, 0x30, 0x30, 0x2D, 0x32, 0x38, 0x30, 0x32, 0x30, 0x31, 0x38,   // 763.0000-2802018
	0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x39, 0x00, 0x57, 0x69, 0x6E, 0x64,   // .Office2019.Wind
	0x6F, 0x77, 0x73, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F,   // ows.Office2010.O
	0x66, 0x66, 0x69, 0x63, 0x65, 0x32, 0x30, 0x31, 0x33, 0x2B, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // ffice2013+.Windo
	0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x57,   // ws Server 2019.W
	0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x28,   // indows 10 2019 (
	0x56, 0x6F, 0x6C, 0x75, 0x6D, 0x65, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // Volume).Windows 
	0x31, 0x30, 0x20, 0x55, 0x6E, 0x6B, 0x6E, 0x6F, 0x77, 0x6E, 0x20, 0x28, 0x56, 0x6F, 0x6C, 0x75,   // 10 Unknown (Volu
	0x6D, 0x65, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x43,   // me).Windows 10 C
	0x68, 0x69, 0x6E, 0x61, 0x20, 0x47, 0x6F, 0x76, 0x65, 0x72, 0x6E, 0x6D, 0x65, 0x6E, 0x74, 0x00,   // hina Government.
	0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20,   // Windows 10 2016 
	0x28, 0x56, 0x6F, 0x6C, 0x75, 0x6D, 0x65, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // (Volume).Windows
	0x20, 0x31, 0x30, 0x20, 0x28, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6C, 0x29, 0x00, 0x57, 0x69, 0x6E,   //  10 (Retail).Win
	0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x32, 0x30, 0x31, 0x35, 0x20, 0x28, 0x56, 0x6F,   // dows 10 2015 (Vo
	0x6C, 0x75, 0x6D, 0x65, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x00,   // lume).Windows 7.
	0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x28, 0x52, 0x65, 0x74, 0x61, 0x69,   // Windows 8 (Retai
	0x6C, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x28, 0x56, 0x6F,   // l).Windows 8 (Vo
	0x6C, 0x75, 0x6D, 0x65, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E,   // lume).Windows 8.
	0x31, 0x20, 0x28, 0x52, 0x65, 0x74, 0x61, 0x69, 0x6C, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // 1 (Retail).Windo
	0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x28, 0x56, 0x6F, 0x6C, 0x75, 0x6D, 0x65, 0x29, 0x00,   // ws 8.1 (Volume).
	0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00,   // Windows Preview.
	0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32,   // Windows Server 2
	0x30, 0x30, 0x38, 0x20, 0x41, 0x20, 0x28, 0x57, 0x65, 0x62, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x48,   // 008 A (Web and H
	0x50, 0x43, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76,   // PC).Windows Serv
	0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x42, 0x20, 0x28, 0x53, 0x74, 0x61, 0x6E, 0x64,   // er 2008 B (Stand
	0x61, 0x72, 0x64, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,   // ard and Enterpri
	0x73, 0x65, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76,   // se).Windows Serv
	0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x43, 0x20, 0x28, 0x44, 0x61, 0x74, 0x61, 0x63,   // er 2008 C (Datac
	0x65, 0x6E, 0x74, 0x65, 0x72, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53,   // enter).Windows S
	0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32, 0x20, 0x41, 0x20,   // erver 2008 R2 A 
	0x28, 0x57, 0x65, 0x62, 0x20, 0x61, 0x6E, 0x64, 0x20, 0x48, 0x50, 0x43, 0x29, 0x00, 0x57, 0x69,   // (Web and HPC).Wi
	0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30,   // ndows Server 200
	0x38, 0x20, 0x52, 0x32, 0x20, 0x42, 0x20, 0x28, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64,   // 8 R2 B (Standard
	0x20, 0x61, 0x6E, 0x64, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x29,   //  and Enterprise)
	0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20,   // .Windows Server 
	0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32, 0x20, 0x43, 0x20, 0x28, 0x44, 0x61, 0x74, 0x61, 0x63,   // 2008 R2 C (Datac
	0x65, 0x6E, 0x74, 0x65, 0x72, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53,   // enter).Windows S
	0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // erver 2012.Windo
	0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x52,   // ws Server 2012 R
	0x32, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,   // 2.Windows Server
	0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65,   //  2016.Windows Se
	0x72, 0x76, 0x65, 0x72, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E,   // rver Preview.Win
	0x64, 0x6F, 0x77, 0x73, 0x20, 0x56, 0x69, 0x73, 0x74, 0x61, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // dows Vista.Offic
	0x65, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x32, 0x30,   // e 2010.Office 20
	0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28,   // 13.Office 2013 (
	0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66,   // Pre-Release).Off
	0x69, 0x63, 0x65, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // ice 2016.Office 
	0x32, 0x30, 0x31, 0x39, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72,   // 2019.Windows Ser
	0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x41, 0x52, 0x4D, 0x36, 0x34, 0x00, 0x57,   // ver 2019 ARM64.W
	0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30,   // indows Server 20
	0x31, 0x39, 0x20, 0x41, 0x7A, 0x75, 0x72, 0x65, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x00, 0x57, 0x69,   // 19 Azure Core.Wi
	0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31,   // ndows Server 201
	0x39, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x00, 0x57, 0x69, 0x6E,   // 9 Datacenter.Win
	0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x39,   // dows Server 2019
	0x20, 0x45, 0x73, 0x73, 0x65, 0x6E, 0x74, 0x69, 0x61, 0x6C, 0x73, 0x00, 0x57, 0x69, 0x6E, 0x64,   //  Essentials.Wind
	0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20,   // ows Server 2019 
	0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // Standard.Windows
	0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x44, 0x61, 0x74,   //  Server 2019 Dat
	0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x20, 0x28, 0x53, 0x65, 0x6D, 0x69, 0x2D, 0x41, 0x6E,   // acenter (Semi-An
	0x6E, 0x75, 0x61, 0x6C, 0x20, 0x43, 0x68, 0x61, 0x6E, 0x6E, 0x65, 0x6C, 0x29, 0x00, 0x57, 0x69,   // nual Channel).Wi
	0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31,   // ndows Server 201
	0x39, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x28, 0x53, 0x65, 0x6D, 0x69,   // 9 Standard (Semi
	0x2D, 0x41, 0x6E, 0x6E, 0x75, 0x61, 0x6C, 0x20, 0x43, 0x68, 0x61, 0x6E, 0x6E, 0x65, 0x6C, 0x29,   // -Annual Channel)
	0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65,   // .Windows 10 Ente
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x4C, 0x54, 0x53, 0x43, 0x20, 0x32, 0x30, 0x31, 0x39,   // rprise LTSC 2019
	0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65,   // .Windows 10 Ente
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x4C, 0x54, 0x53, 0x43, 0x20, 0x32, 0x30, 0x31, 0x39,   // rprise LTSC 2019
	0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E,   //  N.Windows 10 En
	0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x47, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // terprise G.Windo
	0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,   // ws 10 Enterprise
	0x20, 0x47, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45,   //  GN.Windows 10 E
	0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x4C,   // nterprise 2016 L
	0x54, 0x53, 0x42, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45,   // TSB.Windows 10 E
	0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x4C,   // nterprise 2016 L
	0x54, 0x53, 0x42, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30,   // TSB N.Windows 10
	0x20, 0x48, 0x6F, 0x6D, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30,   //  Home.Windows 10
	0x20, 0x48, 0x6F, 0x6D, 0x65, 0x20, 0x43, 0x6F, 0x75, 0x6E, 0x74, 0x72, 0x79, 0x20, 0x53, 0x70,   //  Home Country Sp
	0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31,   // ecific.Windows 1
	0x30, 0x20, 0x48, 0x6F, 0x6D, 0x65, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // 0 Home N.Windows
	0x20, 0x31, 0x30, 0x20, 0x48, 0x6F, 0x6D, 0x65, 0x20, 0x53, 0x69, 0x6E, 0x67, 0x6C, 0x65, 0x20,   //  10 Home Single 
	0x4C, 0x61, 0x6E, 0x67, 0x75, 0x61, 0x67, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // Language.Windows
	0x20, 0x31, 0x30, 0x20, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x00, 0x57, 0x69,   //  10 Education.Wi
	0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69,   // ndows 10 Educati
	0x6F, 0x6E, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20,   // on N.Windows 10 
	0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // Enterprise.Windo
	0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,   // ws 10 Enterprise
	0x20, 0x32, 0x30, 0x31, 0x35, 0x20, 0x4C, 0x54, 0x53, 0x42, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   //  2015 LTSB.Windo
	0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,   // ws 10 Enterprise
	0x20, 0x32, 0x30, 0x31, 0x35, 0x20, 0x4C, 0x54, 0x53, 0x42, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E,   //  2015 LTSB N.Win
	0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,   // dows 10 Enterpri
	0x73, 0x65, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20,   // se N.Windows 10 
	0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x57, 0x6F, 0x72,   // Professional Wor
	0x6B, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // kstation.Windows
	0x20, 0x31, 0x30, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C,   //  10 Professional
	0x20, 0x57, 0x6F, 0x72, 0x6B, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x4E, 0x00, 0x57,   //  Workstation N.W
	0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73,   // indows 10 Profes
	0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31,   // sional.Windows 1
	0x30, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x45,   // 0 Professional E
	0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // ducation.Windows
	0x20, 0x31, 0x30, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C,   //  10 Professional
	0x20, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6F, 0x6E, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E,   //  Education N.Win
	0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69,   // dows 10 Professi
	0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31,   // onal N.Windows 1
	0x30, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50,   // 0 Professional P
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31,   // review.Windows 1
	0x30, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x50, 0x72, 0x65,   // 0 Enterprise Pre
	0x76, 0x69, 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20,   // view.Windows 10 
	0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x56,   // Enterprise for V
	0x69, 0x72, 0x74, 0x75, 0x61, 0x6C, 0x20, 0x44, 0x65, 0x73, 0x6B, 0x74, 0x6F, 0x70, 0x73, 0x00,   // irtual Desktops.
	0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x52, 0x65, 0x6D, 0x6F, 0x74,   // Windows 10 Remot
	0x65, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // e Server.Windows
	0x20, 0x31, 0x30, 0x20, 0x53, 0x20, 0x28, 0x4C, 0x65, 0x61, 0x6E, 0x29, 0x00, 0x57, 0x69, 0x6E,   //  10 S (Lean).Win
	0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,   // dows 7 Enterpris
	0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x20, 0x45, 0x6E, 0x74, 0x65,   // e.Windows 7 Ente
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x45, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // rprise E.Windows
	0x20, 0x37, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x4E, 0x00,   //  7 Enterprise N.
	0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73,   // Windows 7 Profes
	0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37,   // sional.Windows 7
	0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x45, 0x00,   //  Professional E.
	0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73,   // Windows 7 Profes
	0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // sional N.Windows
	0x20, 0x37, 0x20, 0x45, 0x6D, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x20, 0x50, 0x4F, 0x53, 0x52,   //  7 Embedded POSR
	0x65, 0x61, 0x64, 0x79, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x20, 0x45,   // eady.Windows 7 E
	0x6D, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64,   // mbedded Standard
	0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x37, 0x20, 0x54, 0x68, 0x69, 0x6E, 0x50,   // .Windows 7 ThinP
	0x43, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x43, 0x6F, 0x72, 0x65,   // C.Windows 8 Core
	0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20,   // .Windows 8 Core 
	0x43, 0x6F, 0x75, 0x6E, 0x74, 0x72, 0x79, 0x20, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63,   // Country Specific
	0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20,   // .Windows 8 Core 
	0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x43, 0x6F, 0x72, 0x65,   // N.Windows 8 Core
	0x20, 0x53, 0x69, 0x6E, 0x67, 0x6C, 0x65, 0x20, 0x4C, 0x61, 0x6E, 0x67, 0x75, 0x61, 0x67, 0x65,   //  Single Language
	0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65,   // .Windows 8 Profe
	0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x57, 0x4D, 0x43, 0x00, 0x57, 0x69, 0x6E, 0x64,   // ssional WMC.Wind
	0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x45, 0x6D, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x20, 0x49,   // ows 8 Embedded I
	0x6E, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69,   // ndustry Professi
	0x6F, 0x6E, 0x61, 0x6C, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x45,   // onal.Windows 8 E
	0x6D, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x20, 0x49, 0x6E, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79,   // mbedded Industry
	0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64,   //  Enterprise.Wind
	0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65,   // ows 8 Enterprise
	0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72,   // .Windows 8 Enter
	0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // prise N.Windows 
	0x38, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x00, 0x57,   // 8 Professional.W
	0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73,   // indows 8 Profess
	0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // ional N.Windows 
	0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // 8.1 Core.Windows
	0x20, 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x41, 0x52, 0x4D, 0x00, 0x57, 0x69,   //  8.1 Core ARM.Wi
	0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x43,   // ndows 8.1 Core C
	0x6F, 0x75, 0x6E, 0x74, 0x72, 0x79, 0x20, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x00,   // ountry Specific.
	0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65,   // Windows 8.1 Core
	0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x43,   //  N.Windows 8.1 C
	0x6F, 0x72, 0x65, 0x20, 0x53, 0x69, 0x6E, 0x67, 0x6C, 0x65, 0x20, 0x4C, 0x61, 0x6E, 0x67, 0x75,   // ore Single Langu
	0x61, 0x67, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20,   // age.Windows 8.1 
	0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x53, 0x74, 0x75,   // Professional Stu
	0x64, 0x65, 0x6E, 0x74, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31,   // dent.Windows 8.1
	0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x53, 0x74,   //  Professional St
	0x75, 0x64, 0x65, 0x6E, 0x74, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // udent N.Windows 
	0x38, 0x2E, 0x31, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C,   // 8.1 Professional
	0x20, 0x57, 0x4D, 0x43, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31,   //  WMC.Windows 8.1
	0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x43, 0x6F, 0x6E, 0x6E, 0x65, 0x63, 0x74, 0x65, 0x64, 0x00,   //  Core Connected.
	0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65,   // Windows 8.1 Core
	0x20, 0x43, 0x6F, 0x6E, 0x6E, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x43, 0x6F, 0x75, 0x6E, 0x74,   //  Connected Count
	0x72, 0x79, 0x20, 0x53, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63, 0x00, 0x57, 0x69, 0x6E, 0x64,   // ry Specific.Wind
	0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x43, 0x6F, 0x6E,   // ows 8.1 Core Con
	0x6E, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   // nected N.Windows
	0x20, 0x38, 0x2E, 0x31, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x20, 0x43, 0x6F, 0x6E, 0x6E, 0x65, 0x63,   //  8.1 Core Connec
	0x74, 0x65, 0x64, 0x20, 0x53, 0x69, 0x6E, 0x67, 0x6C, 0x65, 0x20, 0x4C, 0x61, 0x6E, 0x67, 0x75,   // ted Single Langu
	0x61, 0x67, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20,   // age.Windows 8.1 
	0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // Enterprise.Windo
	0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73,   // ws 8.1 Enterpris
	0x65, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20,   // e N.Windows 8.1 
	0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x00, 0x57, 0x69, 0x6E,   // Professional.Win
	0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73,   // dows 8.1 Profess
	0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // ional N.Windows 
	0x38, 0x2E, 0x31, 0x20, 0x45, 0x6D, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x20, 0x49, 0x6E, 0x64,   // 8.1 Embedded Ind
	0x75, 0x73, 0x74, 0x72, 0x79, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E,   // ustry Profession
	0x61, 0x6C, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x45,   // al.Windows 8.1 E
	0x6D, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64, 0x20, 0x49, 0x6E, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79,   // mbedded Industry
	0x20, 0x41, 0x75, 0x74, 0x6F, 0x6D, 0x6F, 0x74, 0x69, 0x76, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64,   //  Automotive.Wind
	0x6F, 0x77, 0x73, 0x20, 0x38, 0x2E, 0x31, 0x20, 0x45, 0x6D, 0x62, 0x65, 0x64, 0x64, 0x65, 0x64,   // ows 8.1 Embedded
	0x20, 0x49, 0x6E, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70,   //  Industry Enterp
	0x72, 0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20,   // rise.Windows 10 
	0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69,   // Enterprise Previ
	0x65, 0x77, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x50, 0x72,   // ew.Windows 10 Pr
	0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69,   // ofessional Previ
	0x65, 0x77, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x31, 0x30, 0x20, 0x50, 0x72,   // ew.Windows 10 Pr
	0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x57, 0x4D, 0x43, 0x20, 0x50,   // ofessional WMC P
	0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x38,   // review.Windows 8
	0x2E, 0x78, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // .x Preview.Windo
	0x77, 0x73, 0x20, 0x38, 0x2E, 0x78, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x20, 0x41,   // ws 8.x Preview A
	0x52, 0x4D, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65,   // RM.Windows Serve
	0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x57, 0x65, 0x62, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F,   // r 2008 Web.Windo
	0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x43,   // ws Server 2008 C
	0x6F, 0x6D, 0x70, 0x75, 0x74, 0x65, 0x20, 0x43, 0x6C, 0x75, 0x73, 0x74, 0x65, 0x72, 0x00, 0x57,   // ompute Cluster.W
	0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30,   // indows Server 20
	0x30, 0x38, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x00, 0x57, 0x69, 0x6E, 0x64,   // 08 Standard.Wind
	0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20,   // ows Server 2008 
	0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x6F, 0x75, 0x74,   // Standard without
	0x20, 0x48, 0x79, 0x70, 0x65, 0x72, 0x2D, 0x56, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   //  Hyper-V.Windows
	0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x45, 0x6E, 0x74,   //  Server 2008 Ent
	0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // erprise.Windows 
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x45, 0x6E, 0x74, 0x65,   // Server 2008 Ente
	0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x6F, 0x75, 0x74, 0x20, 0x48,   // rprise without H
	0x79, 0x70, 0x65, 0x72, 0x2D, 0x56, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53,   // yper-V.Windows S
	0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63,   // erver 2008 Datac
	0x65, 0x6E, 0x74, 0x65, 0x72, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65,   // enter.Windows Se
	0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65,   // rver 2008 Datace
	0x6E, 0x74, 0x65, 0x72, 0x20, 0x77, 0x69, 0x74, 0x68, 0x6F, 0x75, 0x74, 0x20, 0x48, 0x79, 0x70,   // nter without Hyp
	0x65, 0x72, 0x2D, 0x56, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72,   // er-V.Windows Ser
	0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x49, 0x74, 0x61,   // ver 2008 for Ita
	0x6E, 0x69, 0x75, 0x6D, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x4D, 0x75, 0x6C,   // nium.Windows Mul
	0x74, 0x69, 0x50, 0x6F, 0x69, 0x6E, 0x74, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32,   // tiPoint Server 2
	0x30, 0x31, 0x30, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76,   // 010.Windows Serv
	0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32, 0x20, 0x57, 0x65, 0x62, 0x00, 0x57,   // er 2008 R2 Web.W
	0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30,   // indows Server 20
	0x30, 0x38, 0x20, 0x52, 0x32, 0x20, 0x48, 0x50, 0x43, 0x20, 0x45, 0x64, 0x69, 0x74, 0x69, 0x6F,   // 08 R2 HPC Editio
	0x6E, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,   // n.Windows Server
	0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72,   //  2008 R2 Standar
	0x64, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,   // d.Windows Server
	0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72,   //  2008 R2 Enterpr
	0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76,   // ise.Windows Serv
	0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63,   // er 2008 R2 Datac
	0x65, 0x6E, 0x74, 0x65, 0x72, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65,   // enter.Windows Se
	0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x30, 0x38, 0x20, 0x52, 0x32, 0x20, 0x66, 0x6F, 0x72,   // rver 2008 R2 for
	0x20, 0x49, 0x74, 0x61, 0x6E, 0x69, 0x75, 0x6D, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72,   //  Itanium Enterpr
	0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76,   // ise.Windows Serv
	0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74,   // er 2012 Datacent
	0x65, 0x72, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65,   // er.Windows Serve
	0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x4D, 0x75, 0x6C, 0x74, 0x69, 0x50, 0x6F, 0x69, 0x6E,   // r 2012 MultiPoin
	0x74, 0x20, 0x50, 0x72, 0x65, 0x6D, 0x69, 0x75, 0x6D, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77,   // t Premium.Window
	0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x4D, 0x75,   // s Server 2012 Mu
	0x6C, 0x74, 0x69, 0x50, 0x6F, 0x69, 0x6E, 0x74, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72,   // ltiPoint Standar
	0x64, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72,   // d.Windows Server
	0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x00, 0x57,   //  2012 Standard.W
	0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30,   // indows Server 20
	0x31, 0x32, 0x20, 0x52, 0x32, 0x20, 0x43, 0x6C, 0x6F, 0x75, 0x64, 0x20, 0x53, 0x74, 0x6F, 0x72,   // 12 R2 Cloud Stor
	0x61, 0x67, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76,   // age.Windows Serv
	0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x52, 0x32, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63,   // er 2012 R2 Datac
	0x65, 0x6E, 0x74, 0x65, 0x72, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65,   // enter.Windows Se
	0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x52, 0x32, 0x20, 0x45, 0x73, 0x73,   // rver 2012 R2 Ess
	0x65, 0x6E, 0x74, 0x69, 0x61, 0x6C, 0x73, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // entials.Windows 
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x32, 0x20, 0x52, 0x32, 0x20, 0x53,   // Server 2012 R2 S
	0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // tandard.Windows 
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x41, 0x7A, 0x75, 0x72,   // Server 2016 Azur
	0x65, 0x20, 0x43, 0x6F, 0x72, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53,   // e Core.Windows S
	0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x43, 0x6C, 0x6F, 0x75, 0x64,   // erver 2016 Cloud
	0x20, 0x53, 0x74, 0x6F, 0x72, 0x61, 0x67, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73,   //  Storage.Windows
	0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x44, 0x61, 0x74,   //  Server 2016 Dat
	0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20,   // acenter.Windows 
	0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x45, 0x73, 0x73, 0x65,   // Server 2016 Esse
	0x6E, 0x74, 0x69, 0x61, 0x6C, 0x73, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53,   // ntials.Windows S
	0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64,   // erver 2016 Stand
	0x61, 0x72, 0x64, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76,   // ard.Windows Serv
	0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x41, 0x52, 0x4D, 0x36, 0x34, 0x00, 0x57, 0x69,   // er 2016 ARM64.Wi
	0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31,   // ndows Server 201
	0x36, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6E, 0x74, 0x65, 0x72, 0x20, 0x28, 0x53, 0x65,   // 6 Datacenter (Se
	0x6D, 0x69, 0x2D, 0x41, 0x6E, 0x6E, 0x75, 0x61, 0x6C, 0x20, 0x43, 0x68, 0x61, 0x6E, 0x6E, 0x65,   // mi-Annual Channe
	0x6C, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65,   // l).Windows Serve
	0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20,   // r 2016 Standard 
	0x28, 0x53, 0x65, 0x6D, 0x69, 0x2D, 0x41, 0x6E, 0x6E, 0x75, 0x61, 0x6C, 0x20, 0x43, 0x68, 0x61,   // (Semi-Annual Cha
	0x6E, 0x6E, 0x65, 0x6C, 0x29, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x53, 0x65,   // nnel).Windows Se
	0x72, 0x76, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65,   // rver 2016 Datace
	0x6E, 0x74, 0x65, 0x72, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x57, 0x69, 0x6E,   // nter Preview.Win
	0x64, 0x6F, 0x77, 0x73, 0x20, 0x56, 0x69, 0x73, 0x74, 0x61, 0x20, 0x42, 0x75, 0x73, 0x69, 0x6E,   // dows Vista Busin
	0x65, 0x73, 0x73, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x56, 0x69, 0x73, 0x74,   // ess.Windows Vist
	0x61, 0x20, 0x42, 0x75, 0x73, 0x69, 0x6E, 0x65, 0x73, 0x73, 0x20, 0x4E, 0x00, 0x57, 0x69, 0x6E,   // a Business N.Win
	0x64, 0x6F, 0x77, 0x73, 0x20, 0x56, 0x69, 0x73, 0x74, 0x61, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72,   // dows Vista Enter
	0x70, 0x72, 0x69, 0x73, 0x65, 0x00, 0x57, 0x69, 0x6E, 0x64, 0x6F, 0x77, 0x73, 0x20, 0x56, 0x69,   // prise.Windows Vi
	0x73, 0x74, 0x61, 0x20, 0x45, 0x6E, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x20, 0x4E,   // sta Enterprise N
	0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x32,   // .Office Access 2
	0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x45, 0x78, 0x63, 0x65, 0x6C,   // 010.Office Excel
	0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x47, 0x72, 0x6F,   //  2010.Office Gro
	0x6F, 0x76, 0x65, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // ove 2010.Office 
	0x49, 0x6E, 0x66, 0x6F, 0x50, 0x61, 0x74, 0x68, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66,   // InfoPath 2010.Of
	0x66, 0x69, 0x63, 0x65, 0x20, 0x4D, 0x6F, 0x6E, 0x64, 0x6F, 0x20, 0x31, 0x20, 0x32, 0x30, 0x31,   // fice Mondo 1 201
	0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4D, 0x6F, 0x6E, 0x64, 0x6F, 0x20, 0x32,   // 0.Office Mondo 2
	0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4F, 0x6E, 0x65,   //  2010.Office One
	0x4E, 0x6F, 0x74, 0x65, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65,   // Note 2010.Office
	0x20, 0x4F, 0x75, 0x74, 0x4C, 0x6F, 0x6F, 0x6B, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66,   //  OutLook 2010.Of
	0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x6F, 0x77, 0x65, 0x72, 0x50, 0x6F, 0x69, 0x6E, 0x74, 0x20,   // fice PowerPoint 
	0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x66,   // 2010.Office Prof
	0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50, 0x6C, 0x75, 0x73, 0x20, 0x32, 0x30,   // essional Plus 20
	0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63,   // 10.Office Projec
	0x74, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // t Pro 2010.Offic
	0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61,   // e Project Standa
	0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50,   // rd 2010.Office P
	0x75, 0x62, 0x6C, 0x69, 0x73, 0x68, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66,   // ublisher 2010.Of
	0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x6D, 0x61, 0x6C, 0x6C, 0x20, 0x42, 0x75, 0x73, 0x69, 0x6E,   // fice Small Busin
	0x65, 0x73, 0x73, 0x20, 0x42, 0x61, 0x73, 0x69, 0x63, 0x73, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00,   // ess Basics 2010.
	0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20,   // Office Standard 
	0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69,   // 2010.Office Visi
	0x6F, 0x20, 0x50, 0x72, 0x65, 0x6D, 0x69, 0x75, 0x6D, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00, 0x4F,   // o Premium 2010.O
	0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x50, 0x72, 0x6F, 0x20,   // ffice Visio Pro 
	0x32, 0x30, 0x31, 0x30, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69,   // 2010.Office Visi
	0x6F, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x30, 0x00,   // o Standard 2010.
	0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x57, 0x6F, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x30,   // Office Word 2010
	0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x32,   // .Office Access 2
	0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x45, 0x78, 0x63, 0x65, 0x6C,   // 013.Office Excel
	0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x49, 0x6E, 0x66,   //  2013.Office Inf
	0x6F, 0x50, 0x61, 0x74, 0x68, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // oPath 2013.Offic
	0x65, 0x20, 0x4C, 0x79, 0x6E, 0x63, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69,   // e Lync 2013.Offi
	0x63, 0x65, 0x20, 0x4D, 0x6F, 0x6E, 0x64, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66,   // ce Mondo 2013.Of
	0x66, 0x69, 0x63, 0x65, 0x20, 0x4F, 0x6E, 0x65, 0x4E, 0x6F, 0x74, 0x65, 0x20, 0x32, 0x30, 0x31,   // fice OneNote 201
	0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4F, 0x75, 0x74, 0x4C, 0x6F, 0x6F, 0x6B,   // 3.Office OutLook
	0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x6F, 0x77,   //  2013.Office Pow
	0x65, 0x72, 0x50, 0x6F, 0x69, 0x6E, 0x74, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66,   // erPoint 2013.Off
	0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C,   // ice Professional
	0x20, 0x50, 0x6C, 0x75, 0x73, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   //  Plus 2013.Offic
	0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30,   // e Project Pro 20
	0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63,   // 13.Office Projec
	0x74, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00,   // t Standard 2013.
	0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x73, 0x68, 0x65, 0x72,   // Office Publisher
	0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x74, 0x61,   //  2013.Office Sta
	0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // ndard 2013.Offic
	0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x33,   // e Visio Pro 2013
	0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x53, 0x74,   // .Office Visio St
	0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66, 0x69,   // andard 2013.Offi
	0x63, 0x65, 0x20, 0x57, 0x6F, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x33, 0x00, 0x4F, 0x66, 0x66,   // ce Word 2013.Off
	0x69, 0x63, 0x65, 0x20, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20,   // ice Access 2013 
	0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66,   // (Pre-Release).Of
	0x66, 0x69, 0x63, 0x65, 0x20, 0x45, 0x78, 0x63, 0x65, 0x6C, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20,   // fice Excel 2013 
	0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66,   // (Pre-Release).Of
	0x66, 0x69, 0x63, 0x65, 0x20, 0x47, 0x72, 0x6F, 0x6F, 0x76, 0x65, 0x20, 0x32, 0x30, 0x31, 0x33,   // fice Groove 2013
	0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F,   //  (Pre-Release).O
	0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x49, 0x6E, 0x66, 0x6F, 0x50, 0x61, 0x74, 0x68, 0x20, 0x32,   // ffice InfoPath 2
	0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65,   // 013 (Pre-Release
	0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4C, 0x79, 0x6E, 0x63, 0x20, 0x32, 0x30,   // ).Office Lync 20
	0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29,   // 13 (Pre-Release)
	0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4D, 0x6F, 0x6E, 0x64, 0x6F, 0x20, 0x32, 0x30,   // .Office Mondo 20
	0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29,   // 13 (Pre-Release)
	0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4F, 0x6E, 0x65, 0x4E, 0x6F, 0x74, 0x65, 0x20,   // .Office OneNote 
	0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73,   // 2013 (Pre-Releas
	0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4F, 0x75, 0x74, 0x6C, 0x6F, 0x6F,   // e).Office Outloo
	0x6B, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65,   // k 2013 (Pre-Rele
	0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x6F, 0x77, 0x65,   // ase).Office Powe
	0x72, 0x50, 0x6F, 0x69, 0x6E, 0x74, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65,   // rPoint 2013 (Pre
	0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65,   // -Release).Office
	0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50, 0x6C,   //  Professional Pl
	0x75, 0x73, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C,   // us 2013 (Pre-Rel
	0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F,   // ease).Office Pro
	0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50,   // ject Pro 2013 (P
	0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69,   // re-Release).Offi
	0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64,   // ce Project Stand
	0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65,   // ard 2013 (Pre-Re
	0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x75,   // lease).Office Pu
	0x62, 0x6C, 0x69, 0x73, 0x68, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72,   // blisher 2013 (Pr
	0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // e-Release).Offic
	0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x33,   // e Visio Pro 2013
	0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F,   //  (Pre-Release).O
	0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x53, 0x74, 0x61, 0x6E,   // ffice Visio Stan
	0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52,   // dard 2013 (Pre-R
	0x65, 0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x57,   // elease).Office W
	0x6F, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x33, 0x20, 0x28, 0x50, 0x72, 0x65, 0x2D, 0x52, 0x65,   // ord 2013 (Pre-Re
	0x6C, 0x65, 0x61, 0x73, 0x65, 0x29, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x41, 0x63,   // lease).Office Ac
	0x63, 0x65, 0x73, 0x73, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65,   // cess 2016.Office
	0x20, 0x45, 0x78, 0x63, 0x65, 0x6C, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69,   //  Excel 2016.Offi
	0x63, 0x65, 0x20, 0x4D, 0x6F, 0x6E, 0x64, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66,   // ce Mondo 2016.Of
	0x66, 0x69, 0x63, 0x65, 0x20, 0x4D, 0x6F, 0x6E, 0x64, 0x6F, 0x20, 0x52, 0x20, 0x32, 0x30, 0x31,   // fice Mondo R 201
	0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4F, 0x6E, 0x65, 0x4E, 0x6F, 0x74, 0x65,   // 6.Office OneNote
	0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x4F, 0x75, 0x74,   //  2016.Office Out
	0x6C, 0x6F, 0x6F, 0x6B, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65,   // look 2016.Office
	0x20, 0x50, 0x6F, 0x77, 0x65, 0x72, 0x70, 0x6F, 0x69, 0x6E, 0x74, 0x20, 0x32, 0x30, 0x31, 0x36,   //  Powerpoint 2016
	0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x66, 0x65, 0x73, 0x73, 0x69,   // .Office Professi
	0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50, 0x6C, 0x75, 0x73, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F,   // onal Plus 2016.O
	0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x72,   // ffice Project Pr
	0x6F, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72,   // o 2016.Office Pr
	0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x43,   // oject Pro 2016 C
	0x32, 0x52, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63,   // 2R.Office Projec
	0x74, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00,   // t Standard 2016.
	0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x53,   // Office Project S
	0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x43, 0x32, 0x52,   // tandard 2016 C2R
	0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x73, 0x68, 0x65,   // .Office Publishe
	0x72, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x6B,   // r 2016.Office Sk
	0x79, 0x70, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20, 0x42, 0x75, 0x73, 0x69, 0x6E, 0x65, 0x73, 0x73,   // ype for Business
	0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x74, 0x61,   //  2016.Office Sta
	0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // ndard 2016.Offic
	0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x36,   // e Visio Pro 2016
	0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x50, 0x72,   // .Office Visio Pr
	0x6F, 0x20, 0x32, 0x30, 0x31, 0x36, 0x20, 0x43, 0x32, 0x52, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // o 2016 C2R.Offic
	0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64,   // e Visio Standard
	0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73,   //  2016.Office Vis
	0x69, 0x6F, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x36,   // io Standard 2016
	0x20, 0x43, 0x32, 0x52, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x57, 0x6F, 0x72, 0x64,   //  C2R.Office Word
	0x20, 0x32, 0x30, 0x31, 0x36, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F,   //  2016.Office Pro
	0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50, 0x6C, 0x75, 0x73, 0x20, 0x32,   // fessional Plus 2
	0x30, 0x31, 0x39, 0x20, 0x43, 0x32, 0x52, 0x20, 0x50, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x00,   // 019 C2R Preview.
	0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50,   // Office Project P
	0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x43, 0x32, 0x52, 0x20, 0x50, 0x72, 0x65, 0x76,   // ro 2019 C2R Prev
	0x69, 0x65, 0x77, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F,   // iew.Office Visio
	0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x39, 0x20, 0x43, 0x32, 0x52, 0x20, 0x50, 0x72,   //  Pro 2019 C2R Pr
	0x65, 0x76, 0x69, 0x65, 0x77, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x41, 0x63, 0x63,   // eview.Office Acc
	0x65, 0x73, 0x73, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // ess 2019.Office 
	0x45, 0x78, 0x63, 0x65, 0x6C, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63,   // Excel 2019.Offic
	0x65, 0x20, 0x4F, 0x75, 0x74, 0x6C, 0x6F, 0x6F, 0x6B, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F,   // e Outlook 2019.O
	0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x6F, 0x77, 0x65, 0x72, 0x70, 0x6F, 0x69, 0x6E, 0x74,   // ffice Powerpoint
	0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F,   //  2019.Office Pro
	0x66, 0x65, 0x73, 0x73, 0x69, 0x6F, 0x6E, 0x61, 0x6C, 0x20, 0x50, 0x6C, 0x75, 0x73, 0x20, 0x32,   // fessional Plus 2
	0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65,   // 019.Office Proje
	0x63, 0x74, 0x20, 0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69,   // ct Pro 2019.Offi
	0x63, 0x65, 0x20, 0x50, 0x72, 0x6F, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64,   // ce Project Stand
	0x61, 0x72, 0x64, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // ard 2019.Office 
	0x50, 0x75, 0x62, 0x6C, 0x69, 0x73, 0x68, 0x65, 0x72, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F,   // Publisher 2019.O
	0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x6B, 0x79, 0x70, 0x65, 0x20, 0x66, 0x6F, 0x72, 0x20,   // ffice Skype for 
	0x42, 0x75, 0x73, 0x69, 0x6E, 0x65, 0x73, 0x73, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66,   // Business 2019.Of
	0x66, 0x69, 0x63, 0x65, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32, 0x30,   // fice Standard 20
	0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x56, 0x69, 0x73, 0x69, 0x6F, 0x20,   // 19.Office Visio 
	0x50, 0x72, 0x6F, 0x20, 0x32, 0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20,   // Pro 2019.Office 
	0x56, 0x69, 0x73, 0x69, 0x6F, 0x20, 0x53, 0x74, 0x61, 0x6E, 0x64, 0x61, 0x72, 0x64, 0x20, 0x32,   // Visio Standard 2
	0x30, 0x31, 0x39, 0x00, 0x4F, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x57, 0x6F, 0x72, 0x64, 0x20,   // 019.Office Word 
	0x32, 0x30, 0x31, 0x39, 0x00,                                                                     // 2019.
};

__pure size_t getDefaultKmsDataSize()
{
	return sizeof(DefaultKmsData);
}

#endif // NO_INTERNAL_DATA

