<?php
require_once './config.php';
require_once './core/PhpImap/__autoload.php';
require_once './functions.php';
require_once './options.php';
date_default_timezone_set($option['timezone']);
session_start();
error_reporting(E_ALL);
$unseen = filter_input(INPUT_GET, 'unseen', FILTER_SANITIZE_STRING);
$count = 0;
if($option['ssl'] == "yes") {
    $mailbox = new PhpImap\Mailbox('{'.$config['host'].'/imap/ssl}INBOX', $config['user'], $config['pass'], __DIR__);
} else {
    $mailbox = new PhpImap\Mailbox('{'.$config['host'].'/imap/novalidate-cert}INBOX', $config['user'], $config['pass'], __DIR__);
}
if (!isset($_SESSION["address"])) {
    if($config['api'] == "yes") {
        if(isset($_GET['email'])) {
            $address = $_GET['email'];
        } else {
            die("DIE");
        }
    } else {
        die("DIE");
    }
} else {
    $address = $_SESSION["address"];
}

$ids = $mailbox->searchMailbox('BEFORE ' . date('d-M-Y', strtotime($option['deleteDays']." days ago")));
foreach ($ids as $id) {
    $mailbox->deleteMail($id);
}
$mailbox->expungeDeletedMails();
$files = glob('downloads/*'); 
foreach($files as $file){
  if(is_file($file))
    unlink($file); 
}
$toList = "TO ".$address;
$ccList = "CC ".$address;
$bccList = "BCC ".$address;
$mailIdsTo = $mailbox->searchMailbox($toList);
$mailIdsCc = $mailbox->searchMailbox($ccList);
$mailIdsBcc = $mailbox->searchMailbox($bccList);
$mailsIds = array_reverse(array_unique(array_merge($mailIdsTo,$mailIdsCc,$mailIdsBcc)));
if($unseen == 1) {
    $unseenIds = $mailbox->searchMailbox("UNSEEN");
    $mailsIds = array_intersect($mailsIds,$unseenIds);
}
if($config['api'] == "yes" && isset($_GET['email'])) {
    if($config["apikey"] != $_GET["apikey"]) {
        exit("Access Denied");
    }
    $allmails = array();
    foreach ($mailsIds as $mailID) {
        $attachmentsDir = "attachments/".$address."/".$mailID;
        if (!file_exists($attachmentsDir)) {
            mkdir($attachmentsDir, 0777, true);
            file_put_contents("attachments/index.html", " ".PHP_EOL , FILE_APPEND | LOCK_EX);
        }
        $mailbox->setAttachmentsDir($attachmentsDir);
        $mail = $mailbox->getMail($mailID);
        $mail->tmail_attachments = array();
        $path = dirname("http://".$_SERVER[HTTP_HOST].$_SERVER[REQUEST_URI]);
        $mail->tmail_delete_url = $path."/actions.php?action=delete&id=".$mailID."&email=".$address;
        $mail->tmail_download_url = $path."/actions.php?action=download&id=".$mailID."&email=".$address;
        if (is_dir($attachmentsDir)){
            if ($dh = opendir($attachmentsDir)){
                while (($file = readdir($dh)) !== false){
                    if ($file == '.' || $file == '..') {
                        continue;
                    }
                    $filePath = $attachmentsDir."/".$file;
                    $file = str_replace(".","",$file);
                    $path = $path."/".$filePath;
                    array_push($mail->tmail_attachments, array($file, $path));
                }
                closedir($dh);
            }
        }
        array_push($allmails, $mail);
    }
    exit(json_encode($allmails));
}
foreach ($mailsIds as $mailID) {
    $attachmentsDir = "attachments/".$address."/".$mailID;
    if (!file_exists($attachmentsDir)) {
        mkdir($attachmentsDir, 0777, true);
        file_put_contents("attachments/index.html", " ".PHP_EOL , FILE_APPEND | LOCK_EX);
    }
    $mailbox->setAttachmentsDir($attachmentsDir);
    $mail = $mailbox->getMail($mailID);
    ?>
    <div class="searchPanel" id="mail<?php echo $mailID; ?>">
        <button class="accordion"><?php echo $mail->subject ?><br>From : <?php echo $mail->fromName; ?>&lt;<?php echo $mail->fromAddress; ?>&gt;</button>
        <div class="panel">    
            <button type="button" class="btn btn-danger deleteButton" onclick="deleteMail(<?php echo $mailID; ?>)">Delete</button>
            <button id="downloadBtn<?php echo $mailID; ?>" type="button" class="btn btn-info downloadButton" onclick="downloadMail(<?php echo $mailID; ?>)">Download</button><br><br><br>
            <p>Date : <?php echo $mail->date; ?><br><br></p>
            <?php if ($mail->textHtml == "") { ?>
            <div><?php echo $mail->textPlain; ?></div><br><br>
            <?php } else { ?>
            <div><?php echo $mail->textHtml; ?></div><br><br>
            <?php } ?>
            
            <?php 
            $attachmentCheck = true;
            if (is_dir($attachmentsDir)){
                if ($dh = opendir($attachmentsDir)){
                    while (($file = readdir($dh)) !== false){
                        if ($file == '.' || $file == '..') {
                            continue;
                        }
                        if($attachmentCheck) {
                            echo "<div class=\"tmail-email-attachments\"><h4>Attachments</h4><br>";
                            $attachmentCheck = false;
                        }
                        $filePath = $attachmentsDir."/".$file;
                        $file = str_replace(".","",$file);
                        ?>
                        <a href="<?php echo $filePath ?>" download><i class="fa fa-arrow-down" aria-hidden="true"></i> <?php echo $file; ?></a>
                        <?
                    }
                    if(!$attachmentCheck) {
                        echo "</div>";
                    }
                    closedir($dh);
                }
            }
            ?>
            To : <?php echo $mail->toString; ?><br><br>
        </div>
    </div>
    <?php
    $count++;
}
if($count==0 && $unseen!=1) {
    echo '<div class="cssload-container"><ul class="cssload-flex-container"><li><span class="cssload-loading"></span></li></div></div>';
}
?>