import {AfterContentInit, Directive, ElementRef, OnDestroy} from '@angular/core';
import {MenuEditor} from './menu-editor.service';
import * as Sortable from 'sortablejs';

@Directive({
    selector: '[reorderMenuItems]'
})
export class ReorderMenuItemsDirective implements AfterContentInit, OnDestroy {
    private sortable: Sortable;

    constructor(
        private el: ElementRef,
        private menus: MenuEditor,
    ) {}

    ngAfterContentInit() {
        this.sortable = new Sortable(this.el.nativeElement, {
            draggable: '.menu-item-container',
            handle: '.drag-handle',
            animation: 250,
            onUpdate: () => {
                const items = this.el.nativeElement.querySelectorAll('.menu-item-container'), ids = [];

                for (let i = 0; i < items.length; i++) {
                    ids.push(items[i].dataset.id);
                }

                this.menus.reorderActiveMenuItems(ids);
            }
        });
    }

    ngOnDestroy() {
        this.sortable.destroy();
    }
}
